/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.common.model;

import java.io.Serializable;
import java.util.Arrays;
import network.oxalis.vefa.peppol.common.code.DigestMethod;

public interface Digest {
    public DigestMethod getMethod();

    public byte[] getValue();

    public static Digest of(DigestMethod method, byte[] value) {
        return new DefaultDigest(method, value);
    }

    public static class DefaultDigest
    implements Digest,
    Serializable {
        private static final long serialVersionUID = -3084522333478217556L;
        private final DigestMethod method;
        private final byte[] value;

        private DefaultDigest(DigestMethod method, byte[] value) {
            this.method = method;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Digest digest = (Digest)o;
            if (this.method != digest.getMethod()) {
                return false;
            }
            return Arrays.equals(this.value, digest.getValue());
        }

        public int hashCode() {
            int result = this.method.hashCode();
            result = 31 * result + Arrays.hashCode(this.value);
            return result;
        }

        @Override
        public DigestMethod getMethod() {
            return this.method;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        public String toString() {
            return "Digest.DefaultDigest(method=" + this.getMethod() + ", value=" + Arrays.toString(this.getValue()) + ")";
        }
    }
}

