/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.identifier;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.net.InetAddress;
import java.net.UnknownHostException;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.commons.identifier.IdentifierConf;

public class HostnameProvider
implements Provider<String> {
    @Inject
    private Settings<IdentifierConf> settings;

    public String get() {
        try {
            String hostname = this.settings.getString((Object)IdentifierConf.HOSTNAME);
            if (hostname.trim().isEmpty()) {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            return hostname;
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Unable to get local hostname.", e);
        }
    }
}

