/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.evidence.rem;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import network.oxalis.vefa.peppol.common.api.SimpleIdentifier;
import network.oxalis.vefa.peppol.common.code.DigestMethod;
import network.oxalis.vefa.peppol.common.lang.PeppolException;
import network.oxalis.vefa.peppol.common.model.Digest;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.InstanceIdentifier;
import network.oxalis.vefa.peppol.common.model.Receipt;
import network.oxalis.vefa.peppol.common.model.Scheme;
import network.oxalis.vefa.peppol.common.model.TransportProtocol;
import network.oxalis.vefa.peppol.evidence.jaxb.receipt.OriginalReceiptType;
import network.oxalis.vefa.peppol.evidence.jaxb.receipt.PeppolRemExtension;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.AttributedElectronicAddressType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.ExtensionType;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.REMEvidenceType;
import network.oxalis.vefa.peppol.evidence.lang.RemEvidenceException;
import network.oxalis.vefa.peppol.evidence.rem.EventCode;
import network.oxalis.vefa.peppol.evidence.rem.EventReason;
import network.oxalis.vefa.peppol.evidence.rem.Evidence;
import network.oxalis.vefa.peppol.evidence.rem.EvidenceTypeInstance;
import network.oxalis.vefa.peppol.evidence.rem.RemHelper;
import org.w3c.dom.Node;

public class EvidenceReader {
    public static Evidence read(Node node) throws RemEvidenceException {
        return EvidenceReader.read(new DOMSource(node));
    }

    public static Evidence read(InputStream inputStream) throws RemEvidenceException {
        return EvidenceReader.read(new StreamSource(inputStream));
    }

    private static Evidence read(Source source) throws RemEvidenceException {
        try {
            Unmarshaller unmarshaller = RemHelper.getUnmarshaller();
            JAXBElement jaxbRemEvidence = unmarshaller.unmarshal(source, REMEvidenceType.class);
            REMEvidenceType remEvidence = (REMEvidenceType)jaxbRemEvidence.getValue();
            if (!"2".equals(remEvidence.getVersion())) {
                throw new RemEvidenceException(String.format("Version '%s' not known.", remEvidence.getVersion()));
            }
            Evidence evidence = Evidence.newInstance();
            evidence = evidence.type(EvidenceTypeInstance.findByLocalName(jaxbRemEvidence.getName().getLocalPart()));
            evidence = evidence.eventCode(EventCode.valueFor(remEvidence.getEventCode()));
            evidence = evidence.eventReason(EventReason.valueForCode(remEvidence.getEventReasons().getEventReason().get(0).getCode()));
            if (remEvidence.getEvidenceIssuerDetails() != null) {
                evidence = evidence.issuer(remEvidence.getEvidenceIssuerDetails().getNamesPostalAddresses().getNamePostalAddress().get(0).getEntityName().getName().get(0));
            }
            evidence = evidence.evidenceIdentifier((SimpleIdentifier)InstanceIdentifier.of((String)remEvidence.getEvidenceIdentifier()));
            if (remEvidence.getEvidenceIssuerPolicyID() != null) {
                evidence = evidence.issuerPolicy(remEvidence.getEvidenceIssuerPolicyID().getPolicyID().get(0));
            }
            evidence = evidence.timestamp(RemHelper.fromXmlGregorianCalendar(remEvidence.getEventTime()));
            evidence = evidence.sender(RemHelper.readElectronicAddressType((AttributedElectronicAddressType)remEvidence.getSenderDetails().getAttributedElectronicAddressOrElectronicAddress().get(0)));
            evidence = evidence.receiver(RemHelper.readElectronicAddressType((AttributedElectronicAddressType)remEvidence.getRecipientsDetails().getEntityDetails().get(0).getAttributedElectronicAddressOrElectronicAddress().get(0)));
            evidence = evidence.digest(Digest.of((DigestMethod)DigestMethod.fromUri((String)remEvidence.getSenderMessageDetails().getDigestMethod().getAlgorithm()), (byte[])remEvidence.getSenderMessageDetails().getDigestValue()));
            if (remEvidence.getSenderMessageDetails().getUAMessageIdentifier() != null) {
                evidence = evidence.documentIdentifier((SimpleIdentifier)InstanceIdentifier.of((String)remEvidence.getSenderMessageDetails().getUAMessageIdentifier()));
            }
            evidence = evidence.messageIdentifier((SimpleIdentifier)InstanceIdentifier.of((String)remEvidence.getSenderMessageDetails().getMessageIdentifierByREMMD()));
            evidence = evidence.documentTypeIdentifier(DocumentTypeIdentifier.of((String)remEvidence.getSenderMessageDetails().getMessageSubject(), (Scheme)Scheme.NONE));
            if (remEvidence.getExtensions() != null) {
                for (ExtensionType extensionType : remEvidence.getExtensions().getExtension()) {
                    for (Object o : extensionType.getContent()) {
                        if (!(o instanceof PeppolRemExtension)) continue;
                        PeppolRemExtension peppolRemExtension = (PeppolRemExtension)o;
                        evidence = evidence.transportProtocol(TransportProtocol.of((String)peppolRemExtension.getTransmissionProtocol()));
                        evidence = evidence.transmissionRole(peppolRemExtension.getTransmissionRole());
                        for (OriginalReceiptType receiptType : peppolRemExtension.getOriginalReceipt()) {
                            evidence = evidence.originalReceipt(Receipt.of((String)receiptType.getType(), (byte[])receiptType.getValue()));
                        }
                    }
                }
            }
            return evidence;
        }
        catch (RemEvidenceException e) {
            throw e;
        }
        catch (JAXBException | PeppolException e) {
            throw new RemEvidenceException("Unable to unmarshal content.", (Exception)e);
        }
    }
}

