/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.persist;

import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import network.oxalis.ng.api.persist.ExceptionPersister;
import network.oxalis.ng.api.persist.PayloadPersister;
import network.oxalis.ng.api.persist.PersisterHandler;
import network.oxalis.ng.api.persist.ReceiptPersister;
import network.oxalis.ng.api.plugin.PluginFactory;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.commons.guice.ImplLoader;
import network.oxalis.ng.commons.guice.OxalisModule;
import network.oxalis.ng.commons.persist.DefaultPersister;
import network.oxalis.ng.commons.persist.DefaultPersisterHandler;
import network.oxalis.ng.commons.persist.NoopPersister;
import network.oxalis.ng.commons.persist.PersisterConf;
import network.oxalis.ng.commons.persist.TempPersister;

public class PersisterModule
extends OxalisModule {
    protected void configure() {
        this.bindSettings(PersisterConf.class);
        this.bindTyped(PayloadPersister.class, DefaultPersister.class);
        this.bindTyped(ReceiptPersister.class, DefaultPersister.class);
        this.bindTyped(ExceptionPersister.class, DefaultPersister.class);
        this.bindTyped(PersisterHandler.class, DefaultPersisterHandler.class);
        this.bindTyped(PayloadPersister.class, NoopPersister.class);
        this.bindTyped(ReceiptPersister.class, NoopPersister.class);
        this.bindTyped(ExceptionPersister.class, NoopPersister.class);
        this.bindTyped(PersisterHandler.class, NoopPersister.class);
        this.bindTyped(PayloadPersister.class, TempPersister.class);
        this.bindTyped(ReceiptPersister.class, TempPersister.class);
        this.bindTyped(ExceptionPersister.class, TempPersister.class);
        this.bindTyped(PersisterHandler.class, TempPersister.class);
    }

    @Provides
    @Singleton
    @Named(value="plugin")
    protected PayloadPersister getPluginPayloadPersister(PluginFactory pluginFactory) {
        return (PayloadPersister)pluginFactory.newInstance(PayloadPersister.class);
    }

    @Provides
    @Singleton
    @Named(value="plugin")
    protected ReceiptPersister getPluginReceiptPersister(PluginFactory pluginFactory) {
        return (ReceiptPersister)pluginFactory.newInstance(ReceiptPersister.class);
    }

    @Provides
    @Singleton
    @Named(value="plugin")
    protected PersisterHandler getPluginPersisterHandler(PluginFactory pluginFactory) {
        return (PersisterHandler)pluginFactory.newInstance(PersisterHandler.class);
    }

    @Provides
    @Singleton
    protected PayloadPersister getPayloadPersister(Injector injector, Settings<PersisterConf> settings) {
        return ImplLoader.get(injector, PayloadPersister.class, settings, PersisterConf.PAYLOAD);
    }

    @Provides
    @Singleton
    protected ReceiptPersister getReceiptPersister(Injector injector, Settings<PersisterConf> settings) {
        return ImplLoader.get(injector, ReceiptPersister.class, settings, PersisterConf.RECEIPT);
    }

    @Provides
    @Singleton
    protected ExceptionPersister getExceptionPersister(Injector injector, Settings<PersisterConf> settings) {
        return ImplLoader.get(injector, ExceptionPersister.class, settings, PersisterConf.EXCEPTION);
    }

    @Provides
    @Singleton
    protected PersisterHandler getPersisterHandler(Injector injector, Settings<PersisterConf> settings) {
        return ImplLoader.get(injector, PersisterHandler.class, settings, PersisterConf.HANDLER);
    }
}

