/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.tracing;

import com.google.inject.Inject;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.util.function.Function;
import network.oxalis.ng.commons.tracing.SpanManager;
import network.oxalis.ng.commons.util.ClosableSpan;

public class SpanManagerImpl
implements SpanManager {
    @Inject
    private Tracer tracer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T runWithinSpan(String spanName, Function<Span, T> function) {
        if (spanName == null) {
            throw new IllegalStateException("spanName needs to be set");
        }
        Span span = this.tracer.spanBuilder(spanName).startSpan();
        try {
            T t = function.apply(span);
            return t;
        }
        finally {
            span.end();
        }
    }

    @Override
    public ClosableSpan startClosableSpan(String spanName) {
        return () -> ((Span)this.tracer.spanBuilder(spanName).startSpan()).end();
    }
}

