/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.filesystem;

import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import network.oxalis.ng.api.filesystem.HomeDetector;
import network.oxalis.ng.api.lang.OxalisLoadingException;
import network.oxalis.ng.commons.util.Sortables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OxalisHomeDirectory {
    private static final Logger log = LoggerFactory.getLogger(OxalisHomeDirectory.class);
    private List<HomeDetector> homeDetectors;

    public OxalisHomeDirectory(List<HomeDetector> homeDetectors) {
        this.homeDetectors = homeDetectors;
    }

    public OxalisHomeDirectory() {
        this(StreamSupport.stream(ServiceLoader.load(HomeDetector.class).spliterator(), false).sorted(Sortables.comparator()).collect(Collectors.toList()));
    }

    public File detect() {
        File directory = ((Stream)this.homeDetectors.stream().sequential()).map(HomeDetector::detect).filter(Objects::nonNull).findFirst().orElseThrow(() -> new OxalisLoadingException("Unable to detect Oxalis home folder."));
        try {
            OxalisHomeDirectory.validateOxalisHomeDirectory(directory);
        }
        catch (OxalisLoadingException ex) {
            log.error(ex.getMessage());
            throw ex;
        }
        return directory;
    }

    private static void validateOxalisHomeDirectory(File oxalisHomeDirectory) {
        if (!oxalisHomeDirectory.exists()) {
            throw new OxalisLoadingException(oxalisHomeDirectory + " does not exist!");
        }
        if (!oxalisHomeDirectory.isDirectory()) {
            throw new OxalisLoadingException(oxalisHomeDirectory + " is not a directory");
        }
        if (!oxalisHomeDirectory.canRead()) {
            throw new OxalisLoadingException(oxalisHomeDirectory + " exists, is a directory but can not be read");
        }
    }
}

