/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.inbound;

import com.google.inject.Inject;
import jakarta.xml.ws.Endpoint;
import jakarta.xml.ws.WebServiceFeature;
import java.util.Arrays;
import network.oxalis.ng.as4.inbound.As4EndpointsPublisher;
import network.oxalis.ng.as4.inbound.As4FaultInHandler;
import network.oxalis.ng.as4.inbound.As4Interceptor;
import network.oxalis.ng.as4.inbound.As4Provider;
import network.oxalis.ng.as4.inbound.AttachmentCleanupInterceptor;
import network.oxalis.ng.as4.inbound.MessagingHandler;
import network.oxalis.ng.as4.inbound.SetPolicyInInterceptor;
import network.oxalis.ng.as4.inbound.SetPolicyOutInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.attachment.As4AttachmentInInterceptor;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.CheckFaultInterceptor;
import org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor;
import org.apache.cxf.binding.soap.interceptor.StartBodyInterceptor;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.interceptor.StaxInEndingInterceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.jaxws.handler.soap.SOAPHandlerFaultInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.MultipleEndpointObserver;
import org.apache.cxf.ws.policy.WSPolicyFeature;
import org.apache.cxf.wsdl.interceptors.AbstractEndpointSelectionInterceptor;

public class As4EndpointsPublisherImpl
implements As4EndpointsPublisher {
    @Inject
    private As4Provider as4Provider;
    @Inject
    private AbstractEndpointSelectionInterceptor endpointSelector;
    @Inject
    private As4FaultInHandler as4FaultInHandler;
    @Inject
    private As4Interceptor oxalisAs4Interceptor;
    @Inject
    private SetPolicyInInterceptor setPolicyInInterceptor;
    @Inject
    private SetPolicyOutInterceptor setPolicyOutInterceptor;

    @Override
    public EndpointImpl publish(Bus bus) {
        EndpointImpl endpoint = (EndpointImpl)Endpoint.publish((String)"/", (Object)this.as4Provider, (WebServiceFeature[])new WebServiceFeature[]{new LoggingFeature(), new WSPolicyFeature()});
        endpoint.getServer().getEndpoint().put((Object)"allow-multiplex-endpoint", (Object)Boolean.TRUE);
        endpoint.getServer().getEndpoint().put((Object)"ws-security.enable.streaming", (Object)false);
        endpoint.getServer().getEndpoint().put((Object)"Endpoint-name", (Object)"Oxalis-AS4");
        endpoint.getBinding().setHandlerChain(Arrays.asList(this.as4FaultInHandler, new MessagingHandler()));
        endpoint.getInInterceptors().add(this.oxalisAs4Interceptor);
        endpoint.getInInterceptors().add(this.setPolicyInInterceptor);
        endpoint.getInInterceptors().add(new AttachmentCleanupInterceptor());
        endpoint.getOutInterceptors().add(this.setPolicyOutInterceptor);
        endpoint.getInFaultInterceptors().add(this.setPolicyInInterceptor);
        endpoint.getOutFaultInterceptors().add(this.setPolicyOutInterceptor);
        MultipleEndpointObserver newMO = new MultipleEndpointObserver(bus){

            protected Message createMessage(Message message) {
                return new SoapMessage(message);
            }
        };
        newMO.getBindingInterceptors().add(new As4AttachmentInInterceptor());
        newMO.getBindingInterceptors().add(new StaxInInterceptor());
        newMO.getBindingInterceptors().add(new StaxInEndingInterceptor());
        newMO.getBindingInterceptors().add(new SOAPHandlerFaultInInterceptor(endpoint.getBinding()));
        newMO.getBindingInterceptors().add(new ReadHeadersInterceptor(bus, (SoapVersion)null));
        newMO.getBindingInterceptors().add(new StartBodyInterceptor());
        newMO.getBindingInterceptors().add(new CheckFaultInterceptor());
        newMO.getRoutingInterceptors().add(this.endpointSelector);
        newMO.getEndpoints().add(endpoint.getServer().getEndpoint());
        endpoint.getServer().getDestination().setMessageObserver((MessageObserver)newMO);
        return endpoint;
    }
}

