/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.util;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import network.oxalis.ng.api.outbound.TransmissionRequest;
import network.oxalis.ng.as4.lang.OxalisAs4TransmissionException;
import network.oxalis.ng.as4.outbound.ActionProvider;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.neethi.Policy;
import org.oasis_open.docs.ebxml_msg.ebms.v3_0.ns.core._200704.CollaborationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class PolicyService {
    private static final Logger log = LoggerFactory.getLogger(PolicyService.class);
    private final ActionProvider actionProvider;

    public PolicyService(ActionProvider actionProvider) {
        this.actionProvider = actionProvider;
    }

    public Policy getPolicy() throws OxalisAs4TransmissionException {
        Bus bus = BusFactory.getThreadDefaultBus();
        return this.getPolicy(bus);
    }

    public Policy getPolicy(Bus bus) throws OxalisAs4TransmissionException {
        return this.getPolicy(this.getDefaultPolicy(), bus);
    }

    public Policy getPolicy(TransmissionRequest request) throws OxalisAs4TransmissionException {
        Bus bus = BusFactory.getThreadDefaultBus();
        return this.getPolicy(request, bus);
    }

    public Policy getPolicy(TransmissionRequest request, Bus bus) throws OxalisAs4TransmissionException {
        String action = this.actionProvider.getAction(request.getHeader().getDocumentType());
        ProcessIdentifier process = request.getHeader().getProcess();
        String service = process.getIdentifier();
        return this.getPolicy(this.getPolicyClasspath(action, service), bus);
    }

    public Policy getPolicy(CollaborationInfo collaborationInfo) throws OxalisAs4TransmissionException {
        Bus bus = BusFactory.getThreadDefaultBus();
        return this.getPolicy(collaborationInfo, bus);
    }

    public Policy getPolicy(CollaborationInfo collaborationInfo, Bus bus) throws OxalisAs4TransmissionException {
        return this.getPolicy(this.getPolicyClasspath(collaborationInfo.getAction(), collaborationInfo.getService().getValue()), bus);
    }

    private Policy getPolicy(String policyClasspath, Bus bus) throws OxalisAs4TransmissionException {
        try {
            log.debug("Policy classpath: {}", (Object)policyClasspath);
            InputStream policyStream = this.getClass().getResourceAsStream(policyClasspath);
            PolicyBuilder builder = (PolicyBuilder)bus.getExtension(PolicyBuilder.class);
            return builder.getPolicy(policyStream);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new OxalisAs4TransmissionException("Failed to get WS Policy", (Throwable)e);
        }
    }

    protected String getPolicyClasspath(String action, String service) {
        return this.getDefaultPolicy();
    }

    protected String getDefaultPolicy() {
        return "/eDeliveryAS4Policy_BST.xml";
    }
}

