/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.cxf.attachment.As4AttachmentDataSource;
import org.apache.cxf.attachment.As4AttachmentImpl;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.attachment.ContentDisposition;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.message.Attachment;

public final class As4AttachmentUtil {
    private As4AttachmentUtil() {
    }

    static String getHeaderValue(List<String> v) {
        if (v != null && !v.isEmpty()) {
            return v.get(0);
        }
        return null;
    }

    static String getHeaderValue(List<String> v, String delim) {
        if (v != null && !v.isEmpty()) {
            return String.join((CharSequence)delim, v);
        }
        return null;
    }

    static String getHeader(Map<String, List<String>> headers, String h) {
        return As4AttachmentUtil.getHeaderValue(headers.get(h));
    }

    static String getHeader(Map<String, List<String>> headers, String h, String delim) {
        return As4AttachmentUtil.getHeaderValue(headers.get(h), delim);
    }

    public static Attachment createAttachment(InputStream stream, Map<String, List<String>> headers) throws IOException {
        InputStream ins;
        String id = AttachmentUtil.cleanContentId((String)As4AttachmentUtil.getHeader(headers, "Content-ID"));
        As4AttachmentImpl att = new As4AttachmentImpl(id);
        String ct = As4AttachmentUtil.getHeader(headers, "Content-Type");
        String cd = As4AttachmentUtil.getHeader(headers, "Content-Disposition");
        String fileName = As4AttachmentUtil.getContentDispositionFileName(cd);
        String encoding = null;
        for (Map.Entry<String, List<String>> e : headers.entrySet()) {
            String name = e.getKey();
            if ("Content-Transfer-Encoding".equalsIgnoreCase(name) && "binary".equalsIgnoreCase(encoding = As4AttachmentUtil.getHeader(headers, name))) {
                att.setXOP(true);
            }
            att.setHeader(name, As4AttachmentUtil.getHeaderValue(e.getValue()));
        }
        if (encoding == null) {
            encoding = "binary";
        }
        if ((ins = AttachmentUtil.decode((InputStream)stream, (String)encoding)) != stream) {
            headers.remove("Content-Transfer-Encoding");
        }
        As4AttachmentDataSource source = new As4AttachmentDataSource(ct, ins);
        if (!StringUtils.isEmpty((String)fileName)) {
            source.setName(FileUtils.stripPath((String)fileName));
        }
        att.setDataHandler(new DataHandler((DataSource)source));
        return att;
    }

    static String getContentDispositionFileName(String cd) {
        if (StringUtils.isEmpty((String)cd)) {
            return null;
        }
        ContentDisposition c = new ContentDisposition(cd);
        String s = c.getParameter("filename");
        if (s == null) {
            s = c.getParameter("name");
        }
        return s;
    }
}

