/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.certvalidator.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.api.CrlCache;
import network.oxalis.commons.certvalidator.util.CrlUtils;

public class DirectoryCrlCache
implements CrlCache {
    private Path folder;

    public DirectoryCrlCache(Path folder) throws IOException {
        this.folder = folder;
        Files.createDirectories(folder, new FileAttribute[0]);
    }

    @Override
    public X509CRL get(String url) throws CertificateValidationException {
        X509CRL x509CRL;
        block9: {
            Path file = this.folder.resolve(this.filterUrl(url));
            if (!Files.exists(file, new LinkOption[0])) {
                return null;
            }
            InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
            try {
                x509CRL = CrlUtils.load(inputStream);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | CRLException e) {
                    return null;
                }
            }
            inputStream.close();
        }
        return x509CRL;
    }

    @Override
    public void set(String url, X509CRL crl) {
        Path file = this.folder.resolve(this.filterUrl(url));
        try (OutputStream outputStream = Files.newOutputStream(file, new OpenOption[0]);){
            CrlUtils.save(outputStream, crl);
        }
        catch (IOException | CRLException exception) {
            // empty catch block
        }
    }

    private String filterUrl(String s) {
        return s.replaceAll("[^a-zA-Z0-9.\\-]", "_");
    }
}

