/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.reader;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.ServiceLoader;
import network.oxalis.vefa.peppol.common.api.PotentiallySigned;
import network.oxalis.vefa.peppol.common.model.ServiceMetadata;
import network.oxalis.vefa.peppol.common.model.ServiceReference;
import network.oxalis.vefa.peppol.lookup.api.FetcherResponse;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.api.MetadataReader;
import network.oxalis.vefa.peppol.lookup.api.Namespace;
import network.oxalis.vefa.peppol.lookup.util.XmlUtils;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;

public class MultiReader
implements MetadataReader {
    private static final List<MetadataReader> METADATA_READERS = Lists.newArrayList(ServiceLoader.load(MetadataReader.class));

    @Override
    public List<ServiceReference> parseServiceGroup(FetcherResponse fetcherResponse) throws LookupException {
        FetcherResponse response = fetcherResponse;
        if (null == fetcherResponse) {
            throw new LookupException("ServiceMetadata element not found or SMP registration is not valid.");
        }
        if (response.getNamespace() == null) {
            response = this.detect(response);
        }
        for (MetadataReader metadataReader : METADATA_READERS) {
            if (!metadataReader.getClass().getAnnotation(Namespace.class).value().equalsIgnoreCase(response.getNamespace())) continue;
            return metadataReader.parseServiceGroup(response);
        }
        throw new LookupException(String.format("Unknown namespace: %s", response.getNamespace()));
    }

    @Override
    public PotentiallySigned<ServiceMetadata> parseServiceMetadata(FetcherResponse fetcherResponse) throws LookupException, PeppolSecurityException {
        FetcherResponse response = fetcherResponse;
        if (null == fetcherResponse) {
            throw new LookupException("ServiceMetadata element not found or SMP registration is Not valid.");
        }
        if (response.getNamespace() == null) {
            response = this.detect(response);
        }
        for (MetadataReader metadataReader : METADATA_READERS) {
            if (!metadataReader.getClass().getAnnotation(Namespace.class).value().equalsIgnoreCase(response.getNamespace())) continue;
            return metadataReader.parseServiceMetadata(response);
        }
        throw new LookupException(String.format("Unknown namespace: %s", response.getNamespace()));
    }

    public FetcherResponse detect(FetcherResponse fetcherResponse) throws LookupException {
        try {
            byte[] fileContent = ByteStreams.toByteArray((InputStream)fetcherResponse.getInputStream());
            String namespace = XmlUtils.extractRootNamespace(new String(fileContent));
            if (namespace != null) {
                return new FetcherResponse(new ByteArrayInputStream(fileContent), namespace);
            }
            throw new LookupException("Unable to detect namespace.");
        }
        catch (IOException e) {
            throw new LookupException(e.getMessage(), e);
        }
    }
}

