/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.inbound;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import network.oxalis.ng.api.inbound.InboundMetadata;
import network.oxalis.ng.api.model.TransmissionIdentifier;
import network.oxalis.ng.api.tag.Tag;
import network.oxalis.ng.api.timestamp.Timestamp;
import network.oxalis.ng.as4.inbound.As4EnvelopeHeader;
import network.oxalis.vefa.peppol.common.model.Digest;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.model.Receipt;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import network.oxalis.vefa.peppol.common.model.TransportProtocol;

public class As4InboundMetadata
implements InboundMetadata {
    private final TransmissionIdentifier transmissionIdentifier;
    private final String conversationId;
    private final Header header;
    private final Date timestamp;
    private final TransportProfile transportProfile;
    private final Digest digest;
    private final Receipt primaryReceipt;
    private final List<Receipt> receipts;
    private final X509Certificate certificate;
    private final As4EnvelopeHeader as4EnvelopeHeader;

    public As4InboundMetadata(TransmissionIdentifier transmissionIdentifier, String conversationId, Header header, Timestamp timestamp, TransportProfile transportProfile, Digest digest, X509Certificate certificate, byte[] primaryReceipt, As4EnvelopeHeader as4EnvelopeHeader) {
        this.transmissionIdentifier = transmissionIdentifier;
        this.conversationId = conversationId;
        this.header = header;
        this.timestamp = timestamp.getDate();
        this.transportProfile = transportProfile;
        this.digest = digest;
        this.certificate = certificate;
        this.primaryReceipt = Receipt.of((String)"message/disposition-notification", (byte[])primaryReceipt);
        ArrayList<Receipt> receipts = new ArrayList<Receipt>();
        receipts.add(this.primaryReceipt);
        if (timestamp.getReceipt().isPresent()) {
            receipts.add((Receipt)timestamp.getReceipt().get());
        }
        this.receipts = Collections.unmodifiableList(receipts);
        this.as4EnvelopeHeader = as4EnvelopeHeader;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public TransmissionIdentifier getTransmissionIdentifier() {
        return this.transmissionIdentifier;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public Header getHeader() {
        return this.header;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Digest getDigest() {
        return this.digest;
    }

    public TransportProtocol getTransportProtocol() {
        return TransportProtocol.AS4;
    }

    public TransportProfile getProtocol() {
        return this.transportProfile;
    }

    public List<Receipt> getReceipts() {
        return this.receipts;
    }

    public Receipt primaryReceipt() {
        return this.primaryReceipt;
    }

    public Tag getTag() {
        return Tag.NONE;
    }

    public As4EnvelopeHeader getAs4EnvelopeHeader() {
        return this.as4EnvelopeHeader;
    }
}

