/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.as4.outbound;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import network.oxalis.ng.api.model.TransmissionIdentifier;
import network.oxalis.ng.api.outbound.TransmissionRequest;
import network.oxalis.ng.api.outbound.TransmissionResponse;
import network.oxalis.ng.api.timestamp.Timestamp;
import network.oxalis.ng.as4.lang.OxalisAs4TransmissionException;
import network.oxalis.vefa.peppol.common.model.Digest;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.model.Receipt;
import network.oxalis.vefa.peppol.common.model.TransportProtocol;

public class As4TransmissionResponse
implements TransmissionResponse {
    private final TransmissionRequest transmissionRequest;
    private final TransmissionIdentifier transmissionIdentifier;
    private final Digest digest;
    private final Receipt receipt;
    private final List<Receipt> receipts;
    private final Date timestamp;
    private final OxalisAs4TransmissionException transmissionException;

    public As4TransmissionResponse(TransmissionIdentifier transmissionIdentifier, TransmissionRequest transmissionRequest, Digest digest, byte[] nativeEvidenceBytes, Timestamp timestamp, Date date) {
        this.transmissionIdentifier = transmissionIdentifier;
        this.transmissionRequest = transmissionRequest;
        this.digest = digest;
        this.receipt = Receipt.of((String)"message/disposition-notification", (byte[])nativeEvidenceBytes);
        this.timestamp = date;
        this.transmissionException = null;
        ArrayList<Receipt> receiptList = new ArrayList<Receipt>();
        receiptList.add(this.receipt);
        timestamp.getReceipt().ifPresent(receiptList::add);
        this.receipts = Collections.unmodifiableList(receiptList);
    }

    public As4TransmissionResponse(TransmissionIdentifier transmissionIdentifier, TransmissionRequest transmissionRequest, OxalisAs4TransmissionException transmissionException) {
        this.transmissionRequest = transmissionRequest;
        this.transmissionIdentifier = transmissionIdentifier;
        this.transmissionException = transmissionException;
        this.digest = null;
        this.receipt = null;
        this.receipts = null;
        this.timestamp = null;
    }

    public Header getHeader() {
        return this.transmissionRequest.getHeader();
    }

    public TransmissionIdentifier getTransmissionIdentifier() {
        return this.transmissionIdentifier;
    }

    public List<Receipt> getReceipts() {
        return this.receipts;
    }

    public Endpoint getEndpoint() {
        return this.transmissionRequest.getEndpoint();
    }

    public Receipt primaryReceipt() {
        return this.receipt;
    }

    public Digest getDigest() {
        return this.digest;
    }

    public TransportProtocol getTransportProtocol() {
        return TransportProtocol.AS4;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public OxalisAs4TransmissionException getTransmissionException() {
        return this.transmissionException;
    }
}

