/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.security;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import lombok.Generated;
import network.oxalis.ng.api.lang.OxalisLoadingException;
import network.oxalis.ng.api.model.AccessPointIdentifier;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.commons.guice.OxalisModule;
import network.oxalis.ng.commons.security.CertificateUtils;
import network.oxalis.ng.commons.security.KeyStoreConf;
import network.oxalis.ng.commons.security.PrivateKeyEntryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateModule
extends OxalisModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateModule.class);

    protected void configure() {
        this.bindSettings(KeyStoreConf.class);
        this.bind(KeyStore.PrivateKeyEntry.class).toProvider(PrivateKeyEntryProvider.class).asEagerSingleton();
    }

    @Provides
    @Singleton
    protected KeyStore getKeyStore(Settings<KeyStoreConf> settings, @Named(value="conf") Path confFolder) {
        Path path = settings.getPath((Object)KeyStoreConf.PATH, confFolder);
        try {
            KeyStore keystore = KeyStore.getInstance("JKS");
            if (Files.notExists(path, new LinkOption[0])) {
                throw new OxalisLoadingException(String.format("Unable to find keystore at '%s'.", path));
            }
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                keystore.load(inputStream, settings.getString((Object)KeyStoreConf.PASSWORD).toCharArray());
            }
            return keystore;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new OxalisLoadingException("Something went wrong during handling of key store.", (Throwable)e);
        }
        catch (IOException e) {
            throw new OxalisLoadingException(String.format("Error during reading of '%s'.", path), (Throwable)e);
        }
    }

    @Provides
    @Singleton
    protected PrivateKey getPrivateKeyEntry(KeyStore keyStore, Settings<KeyStoreConf> settings) {
        try {
            if (!keyStore.containsAlias(settings.getString((Object)KeyStoreConf.KEY_ALIAS))) {
                throw new OxalisLoadingException(String.format("Key alias '%s' is not found in the key store.", settings.getString((Object)KeyStoreConf.KEY_ALIAS)));
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(settings.getString((Object)KeyStoreConf.KEY_ALIAS), settings.getString((Object)KeyStoreConf.KEY_PASSWORD).toCharArray());
            if (privateKey == null) {
                throw new OxalisLoadingException("Unable to load private key due to wrong password.");
            }
            return privateKey;
        }
        catch (UnrecoverableKeyException e) {
            throw new OxalisLoadingException("Unable to load private key due to wrong password.", (Throwable)e);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new OxalisLoadingException("Something went wrong during handling of key store.", (Throwable)e);
        }
    }

    @Provides
    @Singleton
    protected X509Certificate getCertificate(KeyStore keyStore, Settings<KeyStoreConf> settings) {
        try {
            if (!keyStore.containsAlias(settings.getString((Object)KeyStoreConf.KEY_ALIAS))) {
                throw new OxalisLoadingException(String.format("Key alias '%s' is not found in the key store.", settings.getString((Object)KeyStoreConf.KEY_ALIAS)));
            }
            X509Certificate certificate = (X509Certificate)keyStore.getCertificate(settings.getString((Object)KeyStoreConf.KEY_ALIAS));
            log.info("Certificate subject: {}", (Object)certificate.getSubjectX500Principal().toString());
            log.info("Certificate issuer: {}", (Object)certificate.getIssuerX500Principal().toString());
            return certificate;
        }
        catch (KeyStoreException e) {
            throw new OxalisLoadingException("Something went wrong during handling of key store.", (Throwable)e);
        }
    }

    @Provides
    @Singleton
    protected AccessPointIdentifier provideOurAccessPointIdentifier(X509Certificate certificate) {
        return new AccessPointIdentifier(CertificateUtils.extractCommonName(certificate));
    }
}

