/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.commons.http;

import com.google.inject.Provides;
import com.google.inject.Singleton;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.apachehttpclient.v5_2.ApacheHttpClientTelemetry;
import java.time.Duration;
import network.oxalis.ng.api.settings.Settings;
import network.oxalis.ng.commons.guice.OxalisModule;
import network.oxalis.ng.commons.http.HttpConf;
import network.oxalis.ng.commons.util.OxalisVersion;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class ApacheHttpModule
extends OxalisModule {
    private static final String USER_AGENT = String.format("Oxalis %s", OxalisVersion.getVersion());

    protected void configure() {
        this.bindSettings(HttpConf.class);
    }

    @Provides
    @Singleton
    protected PoolingHttpClientConnectionManager getPoolingHttpClientConnectionManager(Settings<HttpConf> settings) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(settings.getInt((Object)HttpConf.POOL_MAX_ROUTE));
        connectionManager.setMaxTotal(settings.getInt((Object)HttpConf.POOL_TOTAL));
        connectionManager.setValidateAfterInactivity(TimeValue.ofSeconds((long)settings.getInt((Object)HttpConf.POOL_VALIDATE_AFTER_INACTIVITY)));
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setTimeToLive(TimeValue.of((Duration)Duration.ofSeconds(settings.getInt((Object)HttpConf.POOL_TIME_TO_LIVE)))).build();
        connectionManager.setDefaultConnectionConfig(connectionConfig);
        return connectionManager;
    }

    @Provides
    @Singleton
    protected RequestConfig getRequestConfig(Settings<HttpConf> settings) {
        return RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)settings.getInt((Object)HttpConf.TIMEOUT_CONNECT))).setResponseTimeout(Timeout.ofMilliseconds((long)settings.getInt((Object)HttpConf.TIMEOUT_READ))).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)settings.getInt((Object)HttpConf.TIMEOUT_SOCKET))).build();
    }

    @Provides
    protected CloseableHttpClient getHttpClient(PoolingHttpClientConnectionManager connectionManager, RequestConfig requestConfig, OpenTelemetry openTelemetry) {
        ApacheHttpClientTelemetry telemetry = ApacheHttpClientTelemetry.builder((OpenTelemetry)openTelemetry).build();
        return HttpClients.custom().setUserAgent(USER_AGENT).setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setConnectionManagerShared(true).useSystemProperties().build();
    }
}

