/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.inbound.tracing;

import com.google.inject.Inject;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import lombok.Generated;
import network.oxalis.ng.commons.tracing.SpanManager;
import network.oxalis.ng.commons.util.ClosableSpan;
import network.oxalis.ng.inbound.tracing.OpenTelemetryTracingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOpenTelemetryTracingFilter
implements OpenTelemetryTracingFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultOpenTelemetryTracingFilter.class);
    @Inject
    private SpanManager spanManager;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String rootSpanName = this.deriveSpanName(servletRequest);
        try (ClosableSpan ignore = this.spanManager.startClosableSpan(rootSpanName);){
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private String deriveSpanName(ServletRequest servletRequest) {
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            return String.format("%s - %s", httpServletRequest.getMethod(), httpServletRequest.getRequestURI());
        }
        log.warn("unable to determine span name from {}, fall back to \"default\"", servletRequest.getClass());
        return "default";
    }
}

