/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.statistics.util;

import java.io.OutputStream;
import java.util.Date;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import network.oxalis.ng.statistics.api.StatisticsTransformer;

public class StatisticsToXmlTransformer
implements StatisticsTransformer {
    private final OutputStream outputStream;
    private XMLStreamWriter xmlStreamWriter;

    public StatisticsToXmlTransformer(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("Required argument outputStream is null");
        }
        this.outputStream = outputStream;
    }

    @Override
    public void startStatistics(Date start, Date end) {
        XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
        try {
            this.xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter(this.outputStream, "UTF-8");
            this.xmlStreamWriter.writeStartDocument("UTF-8", "1.0");
            this.xmlStreamWriter.writeStartElement("peppol-ap-statistics");
            String startString = String.format("%tF %tR", start, start);
            this.xmlStreamWriter.writeAttribute("start", startString);
            String endString = String.format("%tF %tR", end, end);
            this.xmlStreamWriter.writeAttribute("end", endString);
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Unable to create XML stream writer; " + e.getMessage(), e);
        }
    }

    @Override
    public void startEntry() {
        try {
            this.xmlStreamWriter.writeStartElement("entry");
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Unable to write element peppol-ap-statistics; " + e, e);
        }
    }

    @Override
    public void writeAccessPointIdentifier(String accessPointIdentifier) {
        this.writeElementAndContents("access-point-id", accessPointIdentifier);
    }

    @Override
    public void writePeriod(String period) {
        this.writeElementAndContents("period", period);
    }

    @Override
    public void writeDirection(String direction) {
        this.writeElementAndContents("direction", direction);
    }

    private void writeElementAndContents(String elementName, String contents) {
        try {
            this.xmlStreamWriter.writeStartElement(elementName);
            if (contents != null) {
                this.xmlStreamWriter.writeCharacters(contents);
            }
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Unable to write " + elementName + " element with value of " + contents + "; " + e, e);
        }
    }

    @Override
    public void writeParticipantIdentifier(String participantId) {
        this.writeElementAndContents("participant-id", participantId);
    }

    @Override
    public void writeDocumentType(String documentType) {
        this.writeElementAndContents("document-type", documentType);
    }

    @Override
    public void writeProfileId(String profileId) {
        this.writeElementAndContents("profile-id", profileId);
    }

    @Override
    public void writeChannel(String channel) {
        this.writeElementAndContents("channel", channel);
    }

    @Override
    public void writeCount(int count) {
        this.writeElementAndContents("count", "" + count);
    }

    @Override
    public void endEntry() {
        try {
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Unable to write statistics end element " + e, e);
        }
    }

    @Override
    public void endStatistics() {
        try {
            this.xmlStreamWriter.writeEndDocument();
            this.xmlStreamWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new IllegalStateException("Unable to write end of statistics document; " + e.getMessage(), e);
        }
    }
}

