/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.statistics.api;

public enum StatisticsGranularity {
    YEAR("Y"),
    MONTH("M"),
    DAY("D"),
    HOUR("H");

    private final String abbreviation;

    private StatisticsGranularity(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public static StatisticsGranularity valueForAbbreviation(String abbreviation) {
        if (abbreviation == null) {
            throw new IllegalArgumentException("null string is an invalid abbreviation for statistics granularity");
        }
        for (StatisticsGranularity granularity : StatisticsGranularity.values()) {
            if (!granularity.abbreviation.equalsIgnoreCase(abbreviation)) continue;
            return granularity;
        }
        throw new IllegalArgumentException("Invalid abbreviation for statistics granularity: " + abbreviation);
    }
}

