/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.test.asd;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import network.oxalis.ng.api.header.HeaderParser;
import network.oxalis.ng.api.inbound.InboundMetadata;
import network.oxalis.ng.api.lang.OxalisContentException;
import network.oxalis.ng.api.lang.TimestampException;
import network.oxalis.ng.api.model.Direction;
import network.oxalis.ng.api.model.TransmissionIdentifier;
import network.oxalis.ng.api.persist.PersisterHandler;
import network.oxalis.ng.api.timestamp.Timestamp;
import network.oxalis.ng.api.timestamp.TimestampProvider;
import network.oxalis.ng.test.asd.AsdInboundMetadata;
import network.oxalis.vefa.peppol.common.model.Header;

@Singleton
public class AsdServlet
extends HttpServlet {
    @Inject
    private Provider<PersisterHandler> persisterHandlerProvider;
    @Inject
    private TimestampProvider timestampProvider;
    @Inject
    private HeaderParser headerParser;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.getWriter().write("Hello ASD world!");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PersisterHandler persisterHandler = (PersisterHandler)this.persisterHandlerProvider.get();
        TransmissionIdentifier transmissionIdentifier = null;
        Header header = null;
        Path path = null;
        try {
            Timestamp timestamp = this.timestampProvider.generate(null, Direction.IN);
            byte[] content = ByteStreams.toByteArray((InputStream)req.getInputStream());
            transmissionIdentifier = TransmissionIdentifier.of((String)req.getHeader("X-ASD-TransmissionID"));
            header = this.headerParser.parse((InputStream)new ByteArrayInputStream(content));
            path = persisterHandler.persist(transmissionIdentifier, header, (InputStream)new ByteArrayInputStream(content));
            persisterHandler.persist((InboundMetadata)new AsdInboundMetadata(transmissionIdentifier, header, timestamp.getDate()), path);
            resp.setStatus(200);
            resp.setHeader("X-ASD-Status", "OK");
            resp.setHeader("X-ASD-Timestamp", timestamp.getDate().toString());
        }
        catch (OxalisContentException | TimestampException e) {
            persisterHandler.persist(transmissionIdentifier, header, path, (Exception)e);
            resp.setStatus(400);
            resp.setHeader("X-ASD-Status", String.format("ERROR: %s", e.getMessage()));
        }
    }
}

