/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ng.test.dummy;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import network.oxalis.ng.api.model.AccessPointIdentifier;

public class DummyPkiModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    protected KeyStore getKeyStore() throws Exception {
        KeyStore keystore = KeyStore.getInstance("JKS");
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/dummy/app_0000000001.jks");){
            keystore.load(inputStream, "changeit".toCharArray());
        }
        return keystore;
    }

    @Provides
    @Singleton
    protected PrivateKey getPrivateKeyEntry(KeyStore keyStore) throws Exception {
        return (PrivateKey)keyStore.getKey("ap", "changeit".toCharArray());
    }

    @Provides
    @Singleton
    protected X509Certificate getCertificate(KeyStore keyStore) throws Exception {
        return (X509Certificate)keyStore.getCertificate("ap");
    }

    @Provides
    @Singleton
    protected AccessPointIdentifier provideOurAccessPointIdentifier(X509Certificate certificate) {
        return new AccessPointIdentifier("APP_0000000001");
    }

    @Provides
    @Singleton
    protected KeyStore.PrivateKeyEntry getPrivateKey(PrivateKey privateKey, X509Certificate certificate) throws Exception {
        return new KeyStore.PrivateKeyEntry(privateKey, new Certificate[]{certificate});
    }
}

