/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ocsp;

import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import network.oxalis.ocsp.OcspException;
import network.oxalis.ocsp.OcspRequest;
import network.oxalis.ocsp.OcspResponse;
import network.oxalis.ocsp.api.OcspFetcher;
import network.oxalis.ocsp.builder.Properties;
import network.oxalis.ocsp.builder.Property;
import network.oxalis.ocsp.fetcher.UrlOcspFetcher;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

class AbstractOcspClient {
    public static final Property<Boolean> EXCEPTION_ON_NO_PATH = Property.create(false);
    public static final Property<OcspFetcher> FETCHER = Property.create(UrlOcspFetcher.builder().build());
    public static final Property<List<X509Certificate>> INTERMEDIATES = Property.create(Collections.emptyList());
    public static final Property<URI> OVERRIDE_URL = Property.create();
    public static final Property<Boolean> NONCE = Property.create(false);
    protected final Properties properties;

    protected AbstractOcspClient(Properties properties) {
        this.properties = properties;
    }

    protected X509Certificate findIntermediate(X509Certificate certificate) throws OcspException {
        for (X509Certificate issuer : this.properties.get(INTERMEDIATES)) {
            if (!issuer.getSubjectX500Principal().equals(certificate.getIssuerX500Principal())) continue;
            return issuer;
        }
        throw new OcspException("Unable to find issuer '%s'.", certificate.getIssuerX500Principal().getName());
    }

    protected URI detectOcspUri(X509Certificate certificate) throws OcspException {
        byte[] extensionValue = certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (extensionValue == null) {
            OcspException.trigger(this.properties.get(EXCEPTION_ON_NO_PATH), "Unable to detect path for OCSP (%s)", Extension.authorityInfoAccess.getId());
            return null;
        }
        try {
            ASN1Sequence asn1Seq = (ASN1Sequence)X509ExtensionUtil.fromExtensionValue((byte[])extensionValue);
            Enumeration objects = asn1Seq.getObjects();
            while (objects.hasMoreElements()) {
                ASN1TaggedObject location;
                ASN1Sequence obj = (ASN1Sequence)objects.nextElement();
                if (!obj.getObjectAt(0).equals(X509ObjectIdentifiers.id_ad_ocsp) || (location = (ASN1TaggedObject)obj.getObjectAt(1)).getTagNo() != 6) continue;
                ASN1OctetString uri = (ASN1OctetString)location.getObject();
                return URI.create(new String(uri.getOctets()));
            }
        }
        catch (Exception e) {
            throw new OcspException("Exception when reading AIA: '%s'.", (Throwable)e, e.getMessage());
        }
        OcspException.trigger(this.properties.get(EXCEPTION_ON_NO_PATH), "Unable to detect path for OCSP in AIA (%s)", Extension.authorityInfoAccess.getId());
        return null;
    }

    /*
     * Exception decompiling
     */
    protected OcspResponse fetch(OcspRequest ocspReq, URI uri) throws OcspException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

