/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ocsp;

import java.math.BigInteger;
import java.net.URI;
import java.security.cert.X509Certificate;
import network.oxalis.ocsp.AbstractOcspClient;
import network.oxalis.ocsp.CertificateIssuer;
import network.oxalis.ocsp.OcspException;
import network.oxalis.ocsp.OcspRequest;
import network.oxalis.ocsp.OcspResponse;
import network.oxalis.ocsp.OcspResult;
import network.oxalis.ocsp.builder.BuildHandler;
import network.oxalis.ocsp.builder.Builder;
import network.oxalis.ocsp.builder.Properties;

public class OcspMultiClient
extends AbstractOcspClient {
    public static Builder<OcspMultiClient> builder() {
        return new Builder<OcspMultiClient>(new BuildHandler<OcspMultiClient>(){

            @Override
            public OcspMultiClient build(Properties properties) {
                return new OcspMultiClient(properties);
            }
        });
    }

    private OcspMultiClient(Properties properties) {
        super(properties);
    }

    public OcspResult verify(X509Certificate ... certificates) throws OcspException {
        if (certificates.length == 0) {
            return OcspResult.EMPTY;
        }
        X509Certificate issuer = this.findIntermediate(certificates[0]);
        return this.verify(CertificateIssuer.generate(issuer), certificates);
    }

    public OcspResult verify(CertificateIssuer issuer, X509Certificate ... certificates) throws OcspException {
        if (certificates.length == 0) {
            return OcspResult.EMPTY;
        }
        URI uri = (URI)this.properties.get(OVERRIDE_URL);
        if (uri == null && (uri = this.detectOcspUri(certificates[0])) == null) {
            return OcspResult.EMPTY;
        }
        BigInteger[] serialNumbers = new BigInteger[certificates.length];
        for (int i = 0; i < certificates.length; ++i) {
            serialNumbers[i] = certificates[i].getSerialNumber();
        }
        return this.verify(uri, issuer, serialNumbers);
    }

    public OcspResult verify(URI uri, CertificateIssuer issuer, BigInteger ... serialNumbers) throws OcspException {
        OcspRequest request = new OcspRequest();
        request.setIssuer(issuer);
        request.addCertificates(serialNumbers);
        if (((Boolean)this.properties.get(NONCE)).booleanValue()) {
            request.addNonce();
        }
        OcspResponse response = this.fetch(request, uri);
        response.verifyResponse();
        return response.getResult();
    }
}

