/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.outbound.transmission;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import network.oxalis.api.header.HeaderParser;
import network.oxalis.api.lang.OxalisContentException;
import network.oxalis.api.model.Direction;
import network.oxalis.api.outbound.TransmissionMessage;
import network.oxalis.api.tag.Tag;
import network.oxalis.api.tag.TagGenerator;
import network.oxalis.api.transformer.ContentDetector;
import network.oxalis.api.transformer.ContentWrapper;
import network.oxalis.commons.io.PeekingInputStream;
import network.oxalis.commons.tracing.Traceable;
import network.oxalis.outbound.transmission.DefaultTransmissionMessage;
import network.oxalis.vefa.peppol.common.model.Header;

public class TransmissionRequestFactory
extends Traceable {
    private final ContentDetector contentDetector;
    private final ContentWrapper contentWrapper;
    private final TagGenerator tagGenerator;
    private final HeaderParser headerParser;

    @Inject
    public TransmissionRequestFactory(ContentDetector contentDetector, ContentWrapper contentWrapper, TagGenerator tagGenerator, HeaderParser headerParser, Tracer tracer) {
        super(tracer);
        this.contentDetector = contentDetector;
        this.contentWrapper = contentWrapper;
        this.tagGenerator = tagGenerator;
        this.headerParser = headerParser;
    }

    public TransmissionMessage newInstance(InputStream inputStream) throws IOException, OxalisContentException {
        return this.newInstance(inputStream, Tag.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransmissionMessage newInstance(InputStream inputStream, Tag tag) throws IOException, OxalisContentException {
        Span span = this.tracer.spanBuilder(((Object)((Object)this)).getClass().getSimpleName()).startSpan();
        try {
            TransmissionMessage transmissionMessage = this.perform(inputStream, tag);
            return transmissionMessage;
        }
        finally {
            span.end();
        }
    }

    private TransmissionMessage perform(InputStream inputStream, Tag tag) throws IOException, OxalisContentException {
        PeekingInputStream peekingInputStream = new PeekingInputStream(inputStream);
        try {
            Header header = this.readHeaderFromSbdh(peekingInputStream);
            return new DefaultTransmissionMessage(header, peekingInputStream.newInputStream(), this.tagGenerator.generate(Direction.OUT, tag));
        }
        catch (OxalisContentException e) {
            byte[] payload = peekingInputStream.getContent();
            Header header = this.detectHeaderFromContent(payload);
            InputStream wrappedContent = this.wrapContentInSbdh(header, payload);
            return new DefaultTransmissionMessage(header, wrappedContent, this.tagGenerator.generate(Direction.OUT, tag));
        }
    }

    private Header readHeaderFromSbdh(PeekingInputStream peekingInputStream) throws OxalisContentException {
        Span span = this.tracer.spanBuilder("Reading SBDH").startSpan();
        try {
            Header header = this.headerParser.parse((InputStream)peekingInputStream);
            span.setAttribute("identifier", header.getIdentifier().getIdentifier());
            Header header2 = header;
            return header2;
        }
        catch (OxalisContentException e) {
            span.setAttribute("exception", e.getMessage());
            throw e;
        }
        finally {
            span.end();
        }
    }

    private Header detectHeaderFromContent(byte[] payload) throws OxalisContentException {
        Span span = this.tracer.spanBuilder("Detect SBDH from content").startSpan();
        try {
            Header header = this.contentDetector.parse((InputStream)new ByteArrayInputStream(payload));
            span.setAttribute("identifier", header.getIdentifier().getIdentifier());
            Header header2 = header;
            return header2;
        }
        catch (OxalisContentException e) {
            span.setAttribute("exception", e.getMessage());
            throw e;
        }
        finally {
            span.end();
        }
    }

    private InputStream wrapContentInSbdh(Header header, byte[] payload) throws IOException, OxalisContentException {
        Span span = this.tracer.spanBuilder("Wrap content in SBDH").startSpan();
        try {
            InputStream inputStream = this.contentWrapper.wrap((InputStream)new ByteArrayInputStream(payload), header);
            return inputStream;
        }
        catch (OxalisContentException e) {
            span.setAttribute("exception", e.getMessage());
            throw e;
        }
        finally {
            span.end();
        }
    }
}

