/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.persistence.guice;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.sql.DataSource;
import network.oxalis.api.settings.Settings;
import network.oxalis.commons.guice.OxalisModule;
import network.oxalis.commons.settings.SettingsBuilder;
import network.oxalis.persistence.datasource.DbcpDataSourceProvider;
import network.oxalis.persistence.datasource.JndiDataSourceProvider;
import network.oxalis.persistence.util.PersistenceConf;

public class DataSourceModule
extends OxalisModule {
    protected void configure() {
        SettingsBuilder.with((Binder)this.binder(), PersistenceConf.class);
        this.bind(Key.get(DataSource.class, (Annotation)Names.named((String)"dbcp"))).toProvider(DbcpDataSourceProvider.class).in(Singleton.class);
        this.bind(Key.get(DataSource.class, (Annotation)Names.named((String)"jndi"))).toProvider(JndiDataSourceProvider.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    protected DataSource dataSourceProvider(Injector injector, Settings<PersistenceConf> settings) {
        return (DataSource)injector.getInstance(Key.get(DataSource.class, (Annotation)settings.getNamed((Object)PersistenceConf.DATASOURCE)));
    }
}

