/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.persistence.datasource;

import com.google.inject.Provider;
import jakarta.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import lombok.Generated;
import network.oxalis.api.settings.Settings;
import network.oxalis.persistence.util.PersistenceConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiDataSourceProvider
implements Provider<DataSource> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JndiDataSourceProvider.class);
    private final Settings<PersistenceConf> settings;

    @Inject
    public JndiDataSourceProvider(Settings<PersistenceConf> settings) {
        this.settings = settings;
    }

    public DataSource get() {
        String dataSourceJndiName = this.settings.getString((Object)PersistenceConf.JDBC_CONNECTION_URI);
        log.debug("Obtaining data source from JNDI: {}", (Object)dataSourceJndiName);
        try {
            InitialContext initCtx = new InitialContext();
            return (DataSource)initCtx.lookup(dataSourceJndiName);
        }
        catch (NamingException e) {
            throw new IllegalStateException(String.format("Unable to obtain JNDI datasource from '%s'.", dataSourceJndiName), e);
        }
    }
}

