/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.persistence.platform;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collections;
import network.oxalis.api.lang.OxalisLoadingException;
import network.oxalis.persistence.api.JdbcTxManager;
import network.oxalis.persistence.platform.H2Platform;
import network.oxalis.persistence.platform.PlatformProvider;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PlatformProviderTest {
    private JdbcTxManager jdbcTxManager;
    private Connection connection;
    private DatabaseMetaData databaseMetaData;

    @BeforeClass
    public void beforeMethod() {
        this.jdbcTxManager = (JdbcTxManager)Mockito.mock(JdbcTxManager.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        this.databaseMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
    }

    @Test
    public void simple() throws Exception {
        ((JdbcTxManager)Mockito.doReturn((Object)this.connection).when((Object)this.jdbcTxManager)).getConnection();
        ((Connection)Mockito.doReturn((Object)this.databaseMetaData).when((Object)this.connection)).getMetaData();
        ((DatabaseMetaData)Mockito.doReturn((Object)"H2").when((Object)this.databaseMetaData)).getDatabaseProductName();
        H2Platform platform = new H2Platform();
        PlatformProvider platformProvider = new PlatformProvider(this.jdbcTxManager, Collections.singleton(platform));
        Assert.assertEquals((Object)platformProvider.get(), (Object)platform);
    }

    @Test(expectedExceptions={OxalisLoadingException.class})
    public void notFound() throws Exception {
        ((JdbcTxManager)Mockito.doReturn((Object)this.connection).when((Object)this.jdbcTxManager)).getConnection();
        ((Connection)Mockito.doReturn((Object)this.databaseMetaData).when((Object)this.connection)).getMetaData();
        ((DatabaseMetaData)Mockito.doReturn((Object)"MySQL").when((Object)this.databaseMetaData)).getDatabaseProductName();
        H2Platform platform = new H2Platform();
        PlatformProvider platformProvider = new PlatformProvider(this.jdbcTxManager, Collections.singleton(platform));
        platformProvider.get();
    }

    @Test(expectedExceptions={OxalisLoadingException.class})
    public void exception() throws Exception {
        ((JdbcTxManager)Mockito.doReturn((Object)this.connection).when((Object)this.jdbcTxManager)).getConnection();
        ((Connection)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException()}).when((Object)this.connection)).getMetaData();
        H2Platform platform = new H2Platform();
        PlatformProvider platformProvider = new PlatformProvider(this.jdbcTxManager, Collections.singleton(platform));
        platformProvider.get();
    }
}

