/*
 * Decompiled with CFR 0.152.
 */
package brave;

import brave.Clock;
import brave.LazySpan;
import brave.NoopScopedSpan;
import brave.NoopSpan;
import brave.NoopSpanCustomizer;
import brave.RealScopedSpan;
import brave.RealSpan;
import brave.ScopedSpan;
import brave.Span;
import brave.SpanCustomizer;
import brave.SpanCustomizerShield;
import brave.handler.FinishedSpanHandler;
import brave.handler.MutableSpan;
import brave.internal.InternalPropagation;
import brave.internal.Lists;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.internal.recorder.PendingSpan;
import brave.internal.recorder.PendingSpans;
import brave.propagation.CurrentTraceContext;
import brave.propagation.Propagation;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.propagation.TraceIdContext;
import brave.sampler.Sampler;
import java.io.Closeable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class Tracer {
    final Clock clock;
    final Propagation.Factory propagationFactory;
    final FinishedSpanHandler finishedSpanHandler;
    final PendingSpans pendingSpans;
    final Sampler sampler;
    final CurrentTraceContext currentTraceContext;
    final boolean traceId128Bit;
    final boolean supportsJoin;
    final boolean alwaysSampleLocal;
    final AtomicBoolean noop;

    Tracer(Clock clock, Propagation.Factory propagationFactory, FinishedSpanHandler finishedSpanHandler, PendingSpans pendingSpans, Sampler sampler, CurrentTraceContext currentTraceContext, boolean traceId128Bit, boolean supportsJoin, boolean alwaysSampleLocal, AtomicBoolean noop) {
        this.clock = clock;
        this.propagationFactory = propagationFactory;
        this.finishedSpanHandler = finishedSpanHandler;
        this.pendingSpans = pendingSpans;
        this.sampler = sampler;
        this.currentTraceContext = currentTraceContext;
        this.traceId128Bit = traceId128Bit;
        this.supportsJoin = supportsJoin;
        this.alwaysSampleLocal = alwaysSampleLocal;
        this.noop = noop;
    }

    public Tracer withSampler(Sampler sampler) {
        if (sampler == null) {
            throw new NullPointerException("sampler == null");
        }
        return new Tracer(this.clock, this.propagationFactory, this.finishedSpanHandler, this.pendingSpans, sampler, this.currentTraceContext, this.traceId128Bit, this.supportsJoin, this.alwaysSampleLocal, this.noop);
    }

    public Span newTrace() {
        return this._toSpan(this.newRootContext());
    }

    public final Span joinSpan(TraceContext context) {
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (!this.supportsJoin) {
            return this.newChild(context);
        }
        int flags = InternalPropagation.instance.flags(context);
        if (this.alwaysSampleLocal && (flags & 0x20) != 32) {
            flags |= 0x20;
        }
        if ((flags & 4) != 4) {
            flags = InternalPropagation.sampled(this.sampler.isSampled(context.traceId()), flags);
        } else if ((flags & 2) == 2) {
            flags |= 0x10;
        }
        context = InternalPropagation.instance.newTraceContext(flags | 0x40, context.traceIdHigh(), context.traceId(), context.spanId(), context.parentIdAsLong(), context.spanId(), context.extra());
        return this._toSpan(this.propagationFactory.decorate(context));
    }

    public Span newChild(TraceContext parent) {
        if (parent == null) {
            throw new NullPointerException("parent == null");
        }
        return this._toSpan(this.nextContext(parent));
    }

    TraceContext newRootContext() {
        return this.nextContext(64, 0L, 0L, 0L, 0L, Collections.<Object>emptyList());
    }

    TraceContext nextContext(TraceContext parent) {
        return this.nextContext(InternalPropagation.instance.flags(parent), parent.traceIdHigh(), parent.traceId(), parent.localRootId(), parent.spanId(), parent.extra());
    }

    TraceContext nextContext(int flags, long traceIdHigh, long traceId, long localRootId, long parentId, List<Object> extra) {
        if (this.alwaysSampleLocal && (flags & 0x20) != 32) {
            flags |= 0x20;
        }
        long nextId = this.nextId();
        if (traceId == 0L) {
            traceIdHigh = this.traceId128Bit ? Platform.get().nextTraceIdHigh() : 0L;
            traceId = nextId;
        } else {
            flags &= 0xFFFFFFAF;
        }
        long spanId = nextId;
        if ((flags & 4) != 4) {
            flags = InternalPropagation.sampled(this.sampler.isSampled(traceId), flags);
        }
        if (localRootId == 0L) {
            localRootId = spanId;
        }
        return this.propagationFactory.decorate(InternalPropagation.instance.newTraceContext(flags, traceIdHigh, traceId, localRootId, parentId, spanId, extra));
    }

    public Span nextSpan(TraceContextOrSamplingFlags extracted) {
        int flags;
        if (extracted == null) {
            throw new NullPointerException("extracted == null");
        }
        TraceContext context = extracted.context();
        if (context != null) {
            return this.newChild(context);
        }
        TraceIdContext traceIdContext = extracted.traceIdContext();
        if (traceIdContext != null) {
            return this._toSpan(this.nextContext(InternalPropagation.instance.flags(extracted.traceIdContext()), traceIdContext.traceIdHigh(), traceIdContext.traceId(), 0L, 0L, extracted.extra()));
        }
        SamplingFlags samplingFlags = extracted.samplingFlags();
        List<Object> extra = extracted.extra();
        TraceContext implicitParent = this.currentTraceContext.get();
        long traceIdHigh = 0L;
        long traceId = 0L;
        long localRootId = 0L;
        long spanId = 0L;
        if (implicitParent != null) {
            flags = InternalPropagation.instance.flags(implicitParent);
            traceIdHigh = implicitParent.traceIdHigh();
            traceId = implicitParent.traceId();
            localRootId = implicitParent.localRootId();
            spanId = implicitParent.spanId();
            extra = Lists.concatImmutableLists(extra, implicitParent.extra());
        } else {
            flags = InternalPropagation.instance.flags(samplingFlags);
        }
        return this._toSpan(this.nextContext(flags, traceIdHigh, traceId, localRootId, spanId, extra));
    }

    public Span toSpan(TraceContext context) {
        return this._toSpan(this.decorateExternal(context));
    }

    TraceContext decorateExternal(TraceContext context) {
        int flags;
        if (context == null) {
            throw new NullPointerException("context == null");
        }
        if (this.alwaysSampleLocal && ((flags = InternalPropagation.instance.flags(context)) & 0x20) != 32) {
            context = InternalPropagation.instance.withFlags(context, flags | 0x20);
        }
        return this.propagationFactory.decorate(context);
    }

    Span _toSpan(TraceContext decorated) {
        if (this.isNoop(decorated)) {
            return new NoopSpan(decorated);
        }
        PendingSpan pendingSpan = this.pendingSpans.getOrCreate(decorated, false);
        return new RealSpan(decorated, this.pendingSpans, pendingSpan.state(), pendingSpan.clock(), this.finishedSpanHandler);
    }

    public SpanInScope withSpanInScope(@Nullable Span span) {
        return new SpanInScope(this.currentTraceContext.newScope(span != null ? span.context() : null));
    }

    public SpanCustomizer currentSpanCustomizer() {
        TraceContext context = this.currentTraceContext.get();
        if (context == null || this.isNoop(context)) {
            return NoopSpanCustomizer.INSTANCE;
        }
        return new SpanCustomizerShield(this.toSpan(context));
    }

    @Nullable
    public Span currentSpan() {
        TraceContext currentContext = this.currentTraceContext.get();
        if (currentContext == null) {
            return null;
        }
        TraceContext decorated = this.decorateExternal(currentContext);
        if (this.isNoop(decorated)) {
            return new NoopSpan(decorated);
        }
        return new LazySpan(this, decorated);
    }

    public Span nextSpan() {
        TraceContext parent = this.currentTraceContext.get();
        return parent != null ? this.newChild(parent) : this.newTrace();
    }

    public ScopedSpan startScopedSpan(String name) {
        return this.startScopedSpanWithParent(name, null);
    }

    public ScopedSpan startScopedSpanWithParent(String name, @Nullable TraceContext parent) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (parent == null) {
            parent = this.currentTraceContext.get();
        }
        TraceContext context = parent != null ? this.nextContext(parent) : this.newRootContext();
        CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(context);
        if (this.isNoop(context)) {
            return new NoopScopedSpan(context, scope);
        }
        PendingSpan pendingSpan = this.pendingSpans.getOrCreate(context, true);
        Clock clock = pendingSpan.clock();
        MutableSpan state = pendingSpan.state();
        state.name(name);
        return new RealScopedSpan(context, scope, state, clock, this.pendingSpans, this.finishedSpanHandler);
    }

    public String toString() {
        TraceContext currentSpan = this.currentTraceContext.get();
        return "Tracer{" + (currentSpan != null ? "currentSpan=" + currentSpan + ", " : "") + (this.noop.get() ? "noop=true, " : "") + "finishedSpanHandler=" + this.finishedSpanHandler + "}";
    }

    boolean isNoop(TraceContext context) {
        if (this.finishedSpanHandler == FinishedSpanHandler.NOOP || this.noop.get()) {
            return true;
        }
        int flags = InternalPropagation.instance.flags(context);
        if ((flags & 0x20) == 32) {
            return false;
        }
        return (flags & 2) != 2;
    }

    long nextId() {
        long nextId = Platform.get().randomLong();
        while (nextId == 0L) {
            nextId = Platform.get().randomLong();
        }
        return nextId;
    }

    public static final class SpanInScope
    implements Closeable {
        final CurrentTraceContext.Scope scope;

        SpanInScope(CurrentTraceContext.Scope scope) {
            if (scope == null) {
                throw new NullPointerException("scope == null");
            }
            this.scope = scope;
        }

        @Override
        public void close() {
            this.scope.close();
        }

        public String toString() {
            return this.scope.toString();
        }
    }
}

