/*
 * Decompiled with CFR 0.152.
 */
package net.klakegg.pkix.ocsp;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.util.HashMap;
import net.klakegg.pkix.ocsp.CertificateIssuer;
import net.klakegg.pkix.ocsp.CertificateResult;
import net.klakegg.pkix.ocsp.CertificateStatus;
import net.klakegg.pkix.ocsp.IOHelper;
import net.klakegg.pkix.ocsp.OcspException;
import net.klakegg.pkix.ocsp.OcspResult;
import net.klakegg.pkix.ocsp.OcspServerException;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;

class OcspResponse {
    private final URI uri;
    private final OCSPResp ocspResp;

    public static OcspResponse parse(URI uri, InputStream inputStream) throws IOException {
        return new OcspResponse(uri, new OCSPResp(IOHelper.toByteArray(inputStream)));
    }

    private OcspResponse(URI uri, OCSPResp ocspResp) {
        this.uri = uri;
        this.ocspResp = ocspResp;
    }

    public void verifyResponse() throws OcspException {
        switch (this.ocspResp.getStatus()) {
            case 0: {
                break;
            }
            case 1: {
                throw new OcspServerException("Request was malformed.", new Object[0]);
            }
            case 2: {
                throw new OcspServerException("An internal error occurred in the OCSP Server.", new Object[0]);
            }
            case 3: {
                throw new OcspServerException("OCSP server is currently too busy.", new Object[0]);
            }
            case 5: {
                throw new OcspServerException("Signed request is required for this OCSP Server.", new Object[0]);
            }
            case 6: {
                throw new OcspServerException("Your signature was not authorized by the OCSP Server.", new Object[0]);
            }
            default: {
                throw new OcspServerException("Unknown OCSPResponse status code '%s'.", this.ocspResp.getStatus());
            }
        }
    }

    public OcspResult getResult() throws OcspException {
        try {
            Object o = this.ocspResp.getResponseObject();
            if (o instanceof BasicOCSPResp) {
                return this.parseBasicResponse((BasicOCSPResp)o);
            }
            throw new OcspException("Parsing '%s' not supported.", o);
        }
        catch (OCSPException e) {
            throw new OcspException(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    protected OcspResult parseBasicResponse(BasicOCSPResp response) {
        HashMap<BigInteger, CertificateResult> map = new HashMap<BigInteger, CertificateResult>();
        for (SingleResp singleResponse : response.getResponses()) {
            map.put(singleResponse.getCertID().getSerialNumber(), new CertificateResult(this.parseCertificateStatus(singleResponse.getCertStatus()), CertificateIssuer.generate(singleResponse.getCertID()), this.uri, singleResponse.getCertID().getSerialNumber(), singleResponse.getThisUpdate(), singleResponse.getNextUpdate()));
        }
        return new OcspResult(map);
    }

    protected CertificateStatus parseCertificateStatus(org.bouncycastle.cert.ocsp.CertificateStatus certificateStatus) {
        if (certificateStatus == null) {
            return CertificateStatus.GOOD;
        }
        if (certificateStatus instanceof RevokedStatus) {
            return CertificateStatus.REVOKED;
        }
        return CertificateStatus.UNKNOWN;
    }
}

