/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ext.testbed.v1;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import network.oxalis.api.settings.Settings;
import network.oxalis.ext.testbed.v1.TestbedConf;
import network.oxalis.ext.testbed.v1.TestbedJaxb;
import network.oxalis.ext.testbed.v1.TestbedSecurity;
import network.oxalis.ext.testbed.v1.jaxb.ErrorType;
import network.oxalis.ext.testbed.v1.jaxb.InboundType;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TestbedSender {
    private static final Logger log = LoggerFactory.getLogger(TestbedSender.class);
    @Inject
    private TestbedSecurity security;
    @Inject
    private Settings<TestbedConf> settings;
    @Inject
    private CloseableHttpClient httpClient;

    public void send(InboundType inbound) throws IOException {
        try {
            HttpPost httpPost = new HttpPost(this.settings.getString((Object)TestbedConf.CONTROLLER));
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(this.prepareContent(TestbedJaxb.OBJECT_FACTORY.createInbound(inbound)), ContentType.APPLICATION_XML));
            CloseableHttpResponse response = this.send((HttpUriRequest)httpPost);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (JAXBException e) {
            throw new IOException("Unable to create document to send to testbed controller.", e);
        }
    }

    public void send(ErrorType error) {
        try {
            HttpPut httpPut = new HttpPut(this.settings.getString((Object)TestbedConf.CONTROLLER));
            httpPut.setEntity((HttpEntity)new ByteArrayEntity(this.prepareContent(TestbedJaxb.OBJECT_FACTORY.createError(error)), ContentType.APPLICATION_XML));
            CloseableHttpResponse response = this.send((HttpUriRequest)httpPut);
            Throwable throwable = null;
            if (response != null) {
                if (throwable != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    response.close();
                }
            }
        }
        catch (IOException | JAXBException e) {
            log.warn("Unable to send error to testbed controller.", e);
        }
    }

    private byte[] prepareContent(JAXBElement<?> element) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TestbedJaxb.marshaller().marshal(element, (OutputStream)baos);
        return baos.toByteArray();
    }

    private CloseableHttpResponse send(HttpUriRequest request) throws IOException {
        request.addHeader("Authorization", String.format("Digest %s", this.security.getExpectedAuthorization()));
        return this.httpClient.execute(request);
    }
}

