/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.InternalPropagation;
import brave.internal.Lists;
import brave.internal.Nullable;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceIdContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TraceContextOrSamplingFlags {
    public static final TraceContextOrSamplingFlags EMPTY = new TraceContextOrSamplingFlags(3, SamplingFlags.EMPTY, Collections.<Object>emptyList());
    public static final TraceContextOrSamplingFlags NOT_SAMPLED = new TraceContextOrSamplingFlags(3, SamplingFlags.NOT_SAMPLED, Collections.<Object>emptyList());
    public static final TraceContextOrSamplingFlags SAMPLED = new TraceContextOrSamplingFlags(3, SamplingFlags.SAMPLED, Collections.<Object>emptyList());
    public static final TraceContextOrSamplingFlags DEBUG = new TraceContextOrSamplingFlags(3, SamplingFlags.DEBUG, Collections.<Object>emptyList());
    final int type;
    final SamplingFlags value;
    final List<Object> extra;

    public static Builder newBuilder() {
        return new Builder();
    }

    @Nullable
    public Boolean sampled() {
        return this.value.sampled();
    }

    public final boolean sampledLocal() {
        return (this.value.flags & 0x20) == 32;
    }

    @Deprecated
    public TraceContextOrSamplingFlags sampled(@Nullable Boolean sampled) {
        if (sampled != null) {
            return this.sampled((boolean)sampled);
        }
        int flags = this.value.flags;
        flags &= 0xFFFFFFFB;
        if ((flags &= 0xFFFFFFFD) == this.value.flags) {
            return this;
        }
        return this.withFlags(flags);
    }

    public TraceContextOrSamplingFlags sampled(boolean sampled) {
        int flags = InternalPropagation.sampled(sampled, this.value.flags);
        if (flags == this.value.flags) {
            return this;
        }
        return this.withFlags(flags);
    }

    @Nullable
    public TraceContext context() {
        return this.type == 1 ? (TraceContext)this.value : null;
    }

    @Nullable
    public TraceIdContext traceIdContext() {
        return this.type == 2 ? (TraceIdContext)this.value : null;
    }

    @Nullable
    public SamplingFlags samplingFlags() {
        return this.type == 3 ? this.value : null;
    }

    public final List<Object> extra() {
        return this.extra;
    }

    public final Builder toBuilder() {
        Builder result = new Builder();
        result.type = this.type;
        result.value = this.value;
        result.extra = this.extra;
        return result;
    }

    public String toString() {
        return "{value=" + this.value + ", extra=" + this.extra + "}";
    }

    public static TraceContextOrSamplingFlags create(TraceContext context) {
        return new TraceContextOrSamplingFlags(1, context, Collections.<Object>emptyList());
    }

    public static TraceContextOrSamplingFlags create(TraceIdContext traceIdContext) {
        return new TraceContextOrSamplingFlags(2, traceIdContext, Collections.<Object>emptyList());
    }

    public static TraceContextOrSamplingFlags create(SamplingFlags flags) {
        if (flags == SamplingFlags.SAMPLED) {
            return SAMPLED;
        }
        if (flags == SamplingFlags.EMPTY) {
            return EMPTY;
        }
        if (flags == SamplingFlags.NOT_SAMPLED) {
            return NOT_SAMPLED;
        }
        if (flags == SamplingFlags.DEBUG) {
            return DEBUG;
        }
        return new TraceContextOrSamplingFlags(3, flags, Collections.<Object>emptyList());
    }

    public static TraceContextOrSamplingFlags create(@Nullable Boolean sampled, boolean debug) {
        if (debug) {
            return DEBUG;
        }
        if (sampled == null) {
            return EMPTY;
        }
        return sampled != false ? SAMPLED : NOT_SAMPLED;
    }

    TraceContextOrSamplingFlags(int type, SamplingFlags value, List<Object> extra) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (extra == null) {
            throw new NullPointerException("extra == null");
        }
        this.type = type;
        this.value = value;
        this.extra = extra;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TraceContextOrSamplingFlags)) {
            return false;
        }
        TraceContextOrSamplingFlags that = (TraceContextOrSamplingFlags)o;
        return this.type == that.type && this.value.equals(that.value) && this.extra.equals(that.extra);
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.type;
        h *= 1000003;
        h ^= this.value.hashCode();
        h *= 1000003;
        return h ^= this.extra.hashCode();
    }

    TraceContextOrSamplingFlags withFlags(int flags) {
        switch (this.type) {
            case 1: {
                TraceContext context = InternalPropagation.instance.withFlags((TraceContext)this.value, flags);
                return new TraceContextOrSamplingFlags(this.type, context, this.extra);
            }
            case 2: {
                TraceIdContext traceIdContext = this.idContextWithFlags(flags);
                return new TraceContextOrSamplingFlags(this.type, traceIdContext, this.extra);
            }
            case 3: {
                SamplingFlags samplingFlags = SamplingFlags.toSamplingFlags(flags);
                if (this.extra.isEmpty()) {
                    return TraceContextOrSamplingFlags.create(samplingFlags);
                }
                return new TraceContextOrSamplingFlags(this.type, samplingFlags, this.extra);
            }
        }
        throw new AssertionError((Object)"programming error");
    }

    TraceIdContext idContextWithFlags(int flags) {
        TraceIdContext traceIdContext = (TraceIdContext)this.value;
        return new TraceIdContext(flags, traceIdContext.traceIdHigh, traceIdContext.traceId);
    }

    public static final class Builder {
        int type;
        SamplingFlags value;
        List<Object> extra = Collections.emptyList();
        boolean sampledLocal = false;

        public final Builder context(TraceContext context) {
            if (context == null) {
                throw new NullPointerException("context == null");
            }
            this.type = 1;
            this.value = context;
            return this;
        }

        public final Builder traceIdContext(TraceIdContext traceIdContext) {
            if (traceIdContext == null) {
                throw new NullPointerException("traceIdContext == null");
            }
            this.type = 2;
            this.value = traceIdContext;
            return this;
        }

        public Builder sampledLocal() {
            this.sampledLocal = true;
            return this;
        }

        public final Builder samplingFlags(SamplingFlags samplingFlags) {
            if (samplingFlags == null) {
                throw new NullPointerException("samplingFlags == null");
            }
            this.type = 3;
            this.value = samplingFlags;
            return this;
        }

        public final Builder extra(List<Object> extra) {
            if (extra == null) {
                throw new NullPointerException("extra == null");
            }
            this.extra = extra;
            return this;
        }

        public final Builder addExtra(Object extra) {
            if (extra == null) {
                throw new NullPointerException("extra == null");
            }
            if (!(this.extra instanceof ArrayList)) {
                this.extra = new ArrayList<Object>(this.extra);
            }
            this.extra.add(extra);
            return this;
        }

        public final TraceContextOrSamplingFlags build() {
            TraceContextOrSamplingFlags result;
            if (!this.extra.isEmpty() && this.type == 1) {
                TraceContext context = (TraceContext)this.value;
                context = context.extra().isEmpty() ? InternalPropagation.instance.withExtra(context, Lists.ensureImmutable(this.extra)) : InternalPropagation.instance.withExtra(context, Lists.concatImmutableLists(context.extra(), this.extra));
                result = new TraceContextOrSamplingFlags(this.type, context, Collections.<Object>emptyList());
            } else {
                result = new TraceContextOrSamplingFlags(this.type, this.value, Lists.ensureImmutable(this.extra));
            }
            if (!this.sampledLocal) {
                return result;
            }
            return result.withFlags(this.value.flags | 0x20);
        }

        Builder() {
        }
    }
}

