/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.evidence.rem;

import java.security.KeyStore;
import java.util.Date;
import javax.xml.bind.JAXBElement;
import network.oxalis.vefa.peppol.common.api.SimpleIdentifier;
import network.oxalis.vefa.peppol.common.code.DigestMethod;
import network.oxalis.vefa.peppol.common.model.Digest;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.InstanceIdentifier;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.Receipt;
import network.oxalis.vefa.peppol.common.model.TransportProtocol;
import network.oxalis.vefa.peppol.evidence.jaxb.receipt.TransmissionRole;
import network.oxalis.vefa.peppol.evidence.jaxb.rem.REMEvidenceType;
import network.oxalis.vefa.peppol.evidence.lang.RemEvidenceException;
import network.oxalis.vefa.peppol.evidence.rem.EventCode;
import network.oxalis.vefa.peppol.evidence.rem.EventReason;
import network.oxalis.vefa.peppol.evidence.rem.Evidence;
import network.oxalis.vefa.peppol.evidence.rem.EvidenceTypeInstance;
import network.oxalis.vefa.peppol.evidence.rem.RemEvidenceTransformer;
import network.oxalis.vefa.peppol.evidence.rem.SignedEvidenceWriter;
import network.oxalis.vefa.peppol.evidence.rem.SignedRemEvidence;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;
import org.w3c.dom.Document;

public class RemEvidenceBuilder {
    private Evidence evidence;

    protected RemEvidenceBuilder(EvidenceTypeInstance evidenceTypeInstance) {
        this.evidence = Evidence.newInstance().type(evidenceTypeInstance).evidenceIdentifier((SimpleIdentifier)InstanceIdentifier.generateUUID()).timestamp(new Date());
    }

    public RemEvidenceBuilder eventCode(EventCode eventCode) {
        this.evidence = this.evidence.eventCode(eventCode);
        return this;
    }

    public RemEvidenceBuilder eventReason(EventReason eventReason) {
        this.evidence = this.evidence.eventReason(eventReason);
        return this;
    }

    public RemEvidenceBuilder eventTime(Date date) {
        this.evidence = this.evidence.timestamp(date);
        return this;
    }

    public RemEvidenceBuilder evidenceIssuerPolicyID(String evidencePolicyID) {
        this.evidence = this.evidence.issuerPolicy(evidencePolicyID);
        return this;
    }

    public RemEvidenceBuilder evidenceIssuerDetails(String evidenceIssuerDetails) {
        this.evidence = this.evidence.issuer(evidenceIssuerDetails);
        return this;
    }

    public RemEvidenceBuilder senderIdentifier(ParticipantIdentifier senderIdentifier) {
        this.evidence = this.evidence.sender(senderIdentifier);
        return this;
    }

    public RemEvidenceBuilder recipientIdentifer(ParticipantIdentifier recipientIdentifier) {
        this.evidence = this.evidence.receiver(recipientIdentifier);
        return this;
    }

    public RemEvidenceBuilder documentTypeId(DocumentTypeIdentifier documentTypeId) {
        this.evidence = this.evidence.documentTypeIdentifier(documentTypeId);
        return this;
    }

    public RemEvidenceBuilder documentTypeInstanceIdentifier(String documentTypeInstanceId) {
        this.evidence = this.evidence.documentIdentifier((SimpleIdentifier)InstanceIdentifier.of((String)documentTypeInstanceId));
        return this;
    }

    public RemEvidenceBuilder instanceIdentifier(InstanceIdentifier instanceIdentifier) {
        this.evidence = this.evidence.messageIdentifier((SimpleIdentifier)instanceIdentifier);
        return this;
    }

    public RemEvidenceBuilder payloadDigest(byte[] payloadDigest) {
        this.evidence = this.evidence.digest(Digest.of((DigestMethod)DigestMethod.SHA256, (byte[])payloadDigest));
        return this;
    }

    public RemEvidenceBuilder protocolSpecificEvidence(TransmissionRole transmissionRole, TransportProtocol transportProtocol, byte[] protocolSpecificBytes) {
        this.evidence = this.evidence.transmissionRole(transmissionRole).transportProtocol(transportProtocol).originalReceipt(Receipt.of((byte[])protocolSpecificBytes));
        return this;
    }

    public Evidence getEvidence() {
        return this.evidence;
    }

    public SignedRemEvidence buildRemEvidenceInstance(KeyStore.PrivateKeyEntry privateKeyEntry) throws RemEvidenceException {
        try {
            Document signedRemDocument = SignedEvidenceWriter.write(privateKeyEntry, this.evidence);
            JAXBElement<REMEvidenceType> remEvidenceTypeJAXBElement = RemEvidenceTransformer.toJaxb(signedRemDocument);
            return new SignedRemEvidence(remEvidenceTypeJAXBElement, signedRemDocument);
        }
        catch (PeppolSecurityException e) {
            throw new RemEvidenceException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

