/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.sbdh;

import java.io.OutputStream;
import java.util.ArrayList;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLStreamWriter;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.sbdh.SbdhHelper;
import network.oxalis.vefa.peppol.sbdh.lang.SbdhException;
import no.difi.commons.sbdh.jaxb.DocumentIdentification;
import no.difi.commons.sbdh.jaxb.Scope;
import no.difi.commons.sbdh.jaxb.StandardBusinessDocumentHeader;

public interface SbdhWriter {
    public static void write(OutputStream outputStream, Header header) throws SbdhException {
        try {
            XMLStreamWriter streamWriter = SbdhHelper.XML_OUTPUT_FACTORY.createXMLStreamWriter(outputStream, "UTF-8");
            streamWriter.writeStartDocument("UTF-8", "1.0");
            SbdhWriter.write(streamWriter, header);
            streamWriter.writeEndDocument();
            streamWriter.close();
        }
        catch (Exception e) {
            throw new SbdhException("Unable to write SBDH.", e);
        }
    }

    public static void write(XMLStreamWriter streamWriter, Header header) throws SbdhException {
        try {
            StandardBusinessDocumentHeader sbdh = new StandardBusinessDocumentHeader();
            sbdh.setHeaderVersion("1.0");
            sbdh.getSender().add(SbdhHelper.createPartner(header.getSender()));
            sbdh.getReceiver().add(SbdhHelper.createPartner(header.getReceiver()));
            sbdh.setDocumentIdentification(new DocumentIdentification());
            sbdh.getDocumentIdentification().setStandard(header.getInstanceType().getStandard());
            sbdh.getDocumentIdentification().setTypeVersion(header.getInstanceType().getVersion());
            sbdh.getDocumentIdentification().setInstanceIdentifier(header.getIdentifier().getIdentifier());
            sbdh.getDocumentIdentification().setType(header.getInstanceType().getType());
            sbdh.getDocumentIdentification().setCreationDateAndTime(SbdhHelper.toXmlGregorianCalendar(header.getCreationTimestamp()));
            ArrayList<Scope> scopes = new ArrayList<Scope>();
            scopes.add(SbdhHelper.createScope(header.getDocumentType()));
            scopes.add(SbdhHelper.createScope(header.getProcess()));
            header.getArguments().forEach(ai -> scopes.add(SbdhHelper.createScope(ai)));
            sbdh.setBusinessScope(SbdhHelper.createBusinessScope(scopes));
            Marshaller marshaller = SbdhHelper.JAXB_CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.marshal((Object)SbdhHelper.OBJECT_FACTORY.createStandardBusinessDocumentHeader(sbdh), streamWriter);
        }
        catch (Exception e) {
            throw new SbdhException("Unable to write SBDH.", e);
        }
    }
}

