/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.reader;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import network.oxalis.vefa.peppol.common.api.PotentiallySigned;
import network.oxalis.vefa.peppol.common.lang.PeppolRuntimeException;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.Endpoint;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.Period;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessMetadata;
import network.oxalis.vefa.peppol.common.model.Redirect;
import network.oxalis.vefa.peppol.common.model.Scheme;
import network.oxalis.vefa.peppol.common.model.ServiceInformation;
import network.oxalis.vefa.peppol.common.model.ServiceMetadata;
import network.oxalis.vefa.peppol.common.model.ServiceReference;
import network.oxalis.vefa.peppol.common.model.Signed;
import network.oxalis.vefa.peppol.common.model.TransportProfile;
import network.oxalis.vefa.peppol.common.util.ExceptionUtil;
import network.oxalis.vefa.peppol.lookup.api.FetcherResponse;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.api.MetadataReader;
import network.oxalis.vefa.peppol.lookup.api.Namespace;
import network.oxalis.vefa.peppol.lookup.model.DocumentTypeIdentifierWithUri;
import network.oxalis.vefa.peppol.lookup.util.XmlUtils;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;
import network.oxalis.vefa.peppol.security.xmldsig.DomUtils;
import network.oxalis.vefa.peppol.security.xmldsig.XmldsigVerifier;
import no.difi.commons.busdox.jaxb.smp.EndpointType;
import no.difi.commons.busdox.jaxb.smp.ProcessType;
import no.difi.commons.busdox.jaxb.smp.RedirectType;
import no.difi.commons.busdox.jaxb.smp.ServiceGroupType;
import no.difi.commons.busdox.jaxb.smp.ServiceInformationType;
import no.difi.commons.busdox.jaxb.smp.ServiceMetadataReferenceType;
import no.difi.commons.busdox.jaxb.smp.ServiceMetadataType;
import no.difi.commons.busdox.jaxb.smp.SignedServiceMetadataType;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@Namespace(value="http://busdox.org/serviceMetadata/publishing/1.0/")
public class BusdoxReader
implements MetadataReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusdoxReader.class);
    private static JAXBContext jaxbContext;
    private static CertificateFactory certificateFactory;

    @Override
    public List<ServiceReference> parseServiceGroup(FetcherResponse fetcherResponse) throws LookupException {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            ServiceGroupType serviceGroup = (ServiceGroupType)unmarshaller.unmarshal(XmlUtils.streamReader(fetcherResponse.getInputStream()), ServiceGroupType.class).getValue();
            ArrayList<ServiceReference> serviceReferences = new ArrayList<ServiceReference>();
            for (ServiceMetadataReferenceType reference : serviceGroup.getServiceMetadataReferenceCollection().getServiceMetadataReference()) {
                String hrefDocumentTypeIdentifier = URLDecoder.decode(reference.getHref(), "UTF-8").split("/services/")[1];
                String[] parts = hrefDocumentTypeIdentifier.split("::", 2);
                try {
                    serviceReferences.add(ServiceReference.of((DocumentTypeIdentifier)DocumentTypeIdentifierWithUri.of(parts[1], Scheme.of((String)parts[0]), URI.create(reference.getHref())), (ProcessIdentifier[])new ProcessIdentifier[0]));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LOGGER.warn("Unable to parse '{}'.", (Object)hrefDocumentTypeIdentifier);
                }
            }
            return serviceReferences;
        }
        catch (UnsupportedEncodingException | JAXBException | XMLStreamException e) {
            throw new LookupException(e.getMessage(), e);
        }
    }

    @Override
    public PotentiallySigned<ServiceMetadata> parseServiceMetadata(FetcherResponse fetcherResponse) throws LookupException, PeppolSecurityException {
        try {
            Document doc = DomUtils.parse((InputStream)fetcherResponse.getInputStream());
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            JAXBElement result = (JAXBElement)unmarshaller.unmarshal((Source)new DOMSource(doc));
            Object o = result.getValue();
            X509Certificate signer = null;
            if (o instanceof SignedServiceMetadataType) {
                signer = XmldsigVerifier.verify((Document)doc);
                o = ((SignedServiceMetadataType)o).getServiceMetadata();
            }
            if (!(o instanceof ServiceMetadataType)) {
                throw new LookupException("ServiceMetadata element not found.");
            }
            ServiceMetadataType serviceMetadataType = (ServiceMetadataType)o;
            return Signed.of((Object)this.getServiceMetadata(serviceMetadataType), (X509Certificate)signer);
        }
        catch (IOException | CertificateException | JAXBException | ParserConfigurationException | SAXException e) {
            throw new LookupException(e.getMessage(), e);
        }
    }

    public ServiceMetadata getServiceMetadata(ServiceMetadataType serviceMetadataType) throws CertificateException, LookupException {
        ServiceInformationType serviceInformation = serviceMetadataType.getServiceInformation();
        if (serviceInformation != null) {
            return this.getServiceMetadata(serviceInformation);
        }
        RedirectType redirect = serviceMetadataType.getRedirect();
        if (redirect != null) {
            return ServiceMetadata.of((Redirect)Redirect.of((String)redirect.getCertificateUID(), (String)redirect.getHref()));
        }
        throw new LookupException("Expected one of ServiceInformationType or RedirectType");
    }

    public ServiceMetadata getServiceMetadata(ServiceInformationType serviceInformation) throws CertificateException {
        ArrayList processMetadatas = Lists.newArrayList();
        for (ProcessType processType : serviceInformation.getProcessList().getProcess()) {
            ArrayList endpoints = Lists.newArrayList();
            for (EndpointType endpointType : processType.getServiceEndpointList().getEndpoint()) {
                Period period = Period.of((Date)(endpointType.getServiceActivationDate() == null ? null : endpointType.getServiceActivationDate().toGregorianCalendar().getTime()), endpointType.getServiceExpirationDate() == null ? null : endpointType.getServiceExpirationDate().toGregorianCalendar().getTime());
                endpoints.add(Endpoint.of((TransportProfile)TransportProfile.of((String)endpointType.getTransportProfile()), (URI)URI.create(endpointType.getEndpointReference().getAddress().getValue()), (X509Certificate)this.certificateInstance(Base64.decodeBase64((String)endpointType.getCertificate())), (Period)period));
            }
            processMetadatas.add(ProcessMetadata.of((ProcessIdentifier)ProcessIdentifier.of((String)processType.getProcessIdentifier().getValue(), (Scheme)Scheme.of((String)processType.getProcessIdentifier().getScheme())), (List)endpoints));
        }
        return ServiceMetadata.of((ServiceInformation)ServiceInformation.of((ParticipantIdentifier)ParticipantIdentifier.of((String)serviceInformation.getParticipantIdentifier().getValue(), (Scheme)Scheme.of((String)serviceInformation.getParticipantIdentifier().getScheme())), (DocumentTypeIdentifier)DocumentTypeIdentifier.of((String)serviceInformation.getDocumentIdentifier().getValue(), (Scheme)Scheme.of((String)serviceInformation.getDocumentIdentifier().getScheme())), (List)processMetadatas));
    }

    private X509Certificate certificateInstance(byte[] content) throws CertificateException {
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(content));
    }

    static {
        ExceptionUtil.perform(PeppolRuntimeException.class, () -> {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ServiceGroupType.class, SignedServiceMetadataType.class, ServiceMetadataType.class});
            certificateFactory = CertificateFactory.getInstance("X.509");
        });
    }
}

