/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spanmanager.concurrent;

import io.opentracing.Span;
import io.opentracing.contrib.spanmanager.SpanManager;

final class RunnableWithManagedSpan
implements Runnable {
    private final Runnable delegate;
    private final SpanManager spanManager;
    private final Span spanToManage;

    RunnableWithManagedSpan(Runnable runnable, SpanManager spanManager, Span spanToManage) {
        if (runnable == null) {
            throw new NullPointerException("Runnable is <null>.");
        }
        if (spanManager == null) {
            throw new NullPointerException("Span manager is <null>.");
        }
        this.delegate = runnable;
        this.spanManager = spanManager;
        this.spanToManage = spanToManage;
    }

    @Override
    public void run() {
        SpanManager.ManagedSpan managedSpan = this.spanManager.activate(this.spanToManage);
        try {
            this.delegate.run();
        }
        finally {
            managedSpan.deactivate();
        }
    }
}

