/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spanmanager.tracer;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.spanmanager.SpanManager;
import io.opentracing.contrib.spanmanager.tracer.AutoReleasingManagedSpan;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;

final class ManagedSpanBuilder
implements Tracer.SpanBuilder {
    Tracer.SpanBuilder delegate;
    private final SpanManager spanManager;

    ManagedSpanBuilder(Tracer.SpanBuilder delegate, SpanManager spanManager) {
        if (delegate == null) {
            throw new NullPointerException("Delegate SpanBuilder was <null>.");
        }
        if (spanManager == null) {
            throw new NullPointerException("Span manager was <null>.");
        }
        this.delegate = delegate;
        this.spanManager = spanManager;
    }

    Tracer.SpanBuilder rewrap(Tracer.SpanBuilder spanBuilder) {
        if (spanBuilder != null) {
            this.delegate = spanBuilder;
        }
        return this;
    }

    public Span start() {
        return new AutoReleasingManagedSpan(this.spanManager.activate(this.delegate.start()));
    }

    public Tracer.SpanBuilder asChildOf(SpanContext parent) {
        return this.addReference("child_of", parent);
    }

    public Tracer.SpanBuilder asChildOf(Span parent) {
        return this.addReference("child_of", parent.context());
    }

    public Tracer.SpanBuilder addReference(String referenceType, SpanContext context) {
        return this.rewrap(this.delegate.addReference(referenceType, context));
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        return this.rewrap(this.delegate.withTag(key, value));
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        return this.rewrap(this.delegate.withTag(key, value));
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        return this.rewrap(this.delegate.withTag(key, value));
    }

    public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
        return this.rewrap(this.delegate.withStartTimestamp(microseconds));
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        Logger.getLogger(this.getClass().getName()).warning("SpanContext baggageItems() method called for SpanBuilder!");
        return Collections.emptyMap().entrySet();
    }
}

