/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.evidence.rem;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import network.oxalis.vefa.peppol.common.api.SimpleIdentifier;
import network.oxalis.vefa.peppol.common.model.Digest;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.Receipt;
import network.oxalis.vefa.peppol.common.model.TransportProtocol;
import network.oxalis.vefa.peppol.evidence.jaxb.receipt.TransmissionRole;
import network.oxalis.vefa.peppol.evidence.rem.EventCode;
import network.oxalis.vefa.peppol.evidence.rem.EventReason;
import network.oxalis.vefa.peppol.evidence.rem.EvidenceTypeInstance;

public class Evidence
implements Serializable {
    private static final long serialVersionUID = 6577654274153420171L;
    private EvidenceTypeInstance type;
    private EventCode eventCode;
    private EventReason eventReason;
    private String issuer = "Unknown";
    private SimpleIdentifier evidenceIdentifier;
    private Date timestamp;
    private ParticipantIdentifier sender;
    private ParticipantIdentifier receiver;
    private DocumentTypeIdentifier documentTypeIdentifier;
    private SimpleIdentifier documentIdentifier;
    private String issuerPolicy;
    private Digest digest;
    private SimpleIdentifier messageIdentifier;
    private TransportProtocol transportProtocol;
    private TransmissionRole transmissionRole;
    private List<Receipt> originalReceipts = Collections.unmodifiableList(new ArrayList());

    public static Evidence newInstance() {
        return new Evidence();
    }

    private Evidence() {
    }

    private Evidence(EvidenceTypeInstance type, EventCode eventCode, EventReason eventReason, String issuer, SimpleIdentifier evidenceIdentifier, Date timestamp, ParticipantIdentifier sender, ParticipantIdentifier receiver, DocumentTypeIdentifier documentTypeIdentifier, SimpleIdentifier documentIdentifier, String issuerPolicy, Digest digest, SimpleIdentifier messageIdentifier, TransportProtocol transportProtocol, TransmissionRole transmissionRole, List<Receipt> originalReceipts) {
        this.type = type;
        this.eventCode = eventCode;
        this.eventReason = eventReason;
        this.issuer = issuer;
        this.evidenceIdentifier = evidenceIdentifier;
        this.timestamp = timestamp;
        this.sender = sender;
        this.receiver = receiver;
        this.documentTypeIdentifier = documentTypeIdentifier;
        this.documentIdentifier = documentIdentifier;
        this.issuerPolicy = issuerPolicy;
        this.digest = digest;
        this.messageIdentifier = messageIdentifier;
        this.transportProtocol = transportProtocol;
        this.transmissionRole = transmissionRole;
        this.originalReceipts = originalReceipts;
    }

    public EvidenceTypeInstance getType() {
        return this.type;
    }

    public Evidence type(EvidenceTypeInstance type) {
        Evidence evidence = this.copy();
        evidence.type = type;
        return evidence;
    }

    public EventCode getEventCode() {
        return this.eventCode;
    }

    public Evidence eventCode(EventCode eventCode) {
        Evidence evidence = this.copy();
        evidence.eventCode = eventCode;
        return evidence;
    }

    public EventReason getEventReason() {
        return this.eventReason;
    }

    public Evidence eventReason(EventReason eventReason) {
        Evidence evidence = this.copy();
        evidence.eventReason = eventReason;
        return evidence;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public Evidence issuer(String issuer) {
        Evidence evidence = this.copy();
        evidence.issuer = issuer;
        return evidence;
    }

    public SimpleIdentifier getEvidenceIdentifier() {
        return this.evidenceIdentifier;
    }

    public Evidence evidenceIdentifier(SimpleIdentifier evidenceIdentifier) {
        Evidence evidence = this.copy();
        evidence.evidenceIdentifier = evidenceIdentifier;
        return evidence;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Evidence timestamp(Date timestamp) {
        if (timestamp != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(timestamp);
            calendar.set(14, 0);
            timestamp = calendar.getTime();
        }
        Evidence evidence = this.copy();
        evidence.timestamp = timestamp;
        return evidence;
    }

    public Evidence header(Header header) {
        Evidence evidence = this.copy();
        evidence.sender = header.getSender();
        evidence.receiver = header.getReceiver();
        evidence.documentTypeIdentifier = header.getDocumentType();
        evidence.documentIdentifier = header.getIdentifier();
        return evidence;
    }

    public ParticipantIdentifier getSender() {
        return this.sender;
    }

    public Evidence sender(ParticipantIdentifier sender) {
        Evidence evidence = this.copy();
        evidence.sender = sender;
        return evidence;
    }

    public ParticipantIdentifier getReceiver() {
        return this.receiver;
    }

    public Evidence receiver(ParticipantIdentifier receiver) {
        Evidence evidence = this.copy();
        evidence.receiver = receiver;
        return evidence;
    }

    public DocumentTypeIdentifier getDocumentTypeIdentifier() {
        return this.documentTypeIdentifier;
    }

    public Evidence documentTypeIdentifier(DocumentTypeIdentifier documentTypeIdentifier) {
        Evidence evidence = this.copy();
        evidence.documentTypeIdentifier = documentTypeIdentifier;
        return evidence;
    }

    public SimpleIdentifier getDocumentIdentifier() {
        return this.documentIdentifier;
    }

    public Evidence documentIdentifier(SimpleIdentifier documentIdentifier) {
        Evidence evidence = this.copy();
        evidence.documentIdentifier = documentIdentifier;
        return evidence;
    }

    public String getIssuerPolicy() {
        return this.issuerPolicy;
    }

    public Evidence issuerPolicy(String issuerPolicy) {
        Evidence evidence = this.copy();
        evidence.issuerPolicy = issuerPolicy;
        return evidence;
    }

    public Digest getDigest() {
        return this.digest;
    }

    public Evidence digest(Digest digest) {
        Evidence evidence = this.copy();
        evidence.digest = digest;
        return evidence;
    }

    public SimpleIdentifier getMessageIdentifier() {
        return this.messageIdentifier;
    }

    public Evidence messageIdentifier(SimpleIdentifier messageIdentifier) {
        Evidence evidence = this.copy();
        evidence.messageIdentifier = messageIdentifier;
        return evidence;
    }

    public TransportProtocol getTransportProtocol() {
        return this.transportProtocol;
    }

    public Evidence transportProtocol(TransportProtocol transportProtocol) {
        Evidence evidence = this.copy();
        evidence.transportProtocol = transportProtocol;
        return evidence;
    }

    public TransmissionRole getTransmissionRole() {
        return this.transmissionRole;
    }

    public Evidence transmissionRole(TransmissionRole transmissionRole) {
        Evidence evidence = this.copy();
        evidence.transmissionRole = transmissionRole;
        return evidence;
    }

    public List<Receipt> getOriginalReceipts() {
        return this.originalReceipts;
    }

    public Evidence originalReceipt(Receipt receipt) {
        return this.originalReceipts(Collections.singletonList(receipt));
    }

    public Evidence originalReceipts(List<Receipt> receipts) {
        List<Receipt> originalReceipts = new ArrayList<Receipt>(this.originalReceipts);
        for (Receipt receipt : receipts) {
            if (receipt == null) continue;
            originalReceipts.add(receipt);
        }
        originalReceipts = Collections.unmodifiableList(originalReceipts);
        Evidence evidence = this.copy();
        evidence.originalReceipts = originalReceipts;
        return evidence;
    }

    protected boolean hasPeppolExtensionValues() {
        return this.transmissionRole != null || this.transportProtocol != null || this.originalReceipts.size() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Evidence evidence = (Evidence)o;
        if (this.type != evidence.type) {
            return false;
        }
        if (this.eventCode != evidence.eventCode) {
            return false;
        }
        if (this.eventReason != evidence.eventReason) {
            return false;
        }
        if (this.issuer != null ? !this.issuer.equals(evidence.issuer) : evidence.issuer != null) {
            return false;
        }
        if (this.evidenceIdentifier != null ? !this.evidenceIdentifier.equals(evidence.evidenceIdentifier) : evidence.evidenceIdentifier != null) {
            return false;
        }
        if (this.timestamp != null ? !this.timestamp.equals(evidence.timestamp) : evidence.timestamp != null) {
            return false;
        }
        if (this.sender != null ? !this.sender.equals((Object)evidence.sender) : evidence.sender != null) {
            return false;
        }
        if (this.receiver != null ? !this.receiver.equals((Object)evidence.receiver) : evidence.receiver != null) {
            return false;
        }
        if (this.documentTypeIdentifier != null ? !this.documentTypeIdentifier.equals((Object)evidence.documentTypeIdentifier) : evidence.documentTypeIdentifier != null) {
            return false;
        }
        if (this.documentIdentifier != null ? !this.documentIdentifier.equals(evidence.documentIdentifier) : evidence.documentIdentifier != null) {
            return false;
        }
        if (this.issuerPolicy != null ? !this.issuerPolicy.equals(evidence.issuerPolicy) : evidence.issuerPolicy != null) {
            return false;
        }
        if (this.digest != null ? !this.digest.equals(evidence.digest) : evidence.digest != null) {
            return false;
        }
        if (this.messageIdentifier != null ? !this.messageIdentifier.equals(evidence.messageIdentifier) : evidence.messageIdentifier != null) {
            return false;
        }
        if (this.transportProtocol != null ? !this.transportProtocol.equals((Object)evidence.transportProtocol) : evidence.transportProtocol != null) {
            return false;
        }
        if (this.transmissionRole != evidence.transmissionRole) {
            return false;
        }
        return this.originalReceipts.equals(evidence.originalReceipts);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.eventCode != null ? this.eventCode.hashCode() : 0);
        result = 31 * result + (this.eventReason != null ? this.eventReason.hashCode() : 0);
        result = 31 * result + (this.issuer != null ? this.issuer.hashCode() : 0);
        result = 31 * result + (this.evidenceIdentifier != null ? this.evidenceIdentifier.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + (this.sender != null ? this.sender.hashCode() : 0);
        result = 31 * result + (this.receiver != null ? this.receiver.hashCode() : 0);
        result = 31 * result + (this.documentTypeIdentifier != null ? this.documentTypeIdentifier.hashCode() : 0);
        result = 31 * result + (this.documentIdentifier != null ? this.documentIdentifier.hashCode() : 0);
        result = 31 * result + (this.issuerPolicy != null ? this.issuerPolicy.hashCode() : 0);
        result = 31 * result + (this.digest != null ? this.digest.hashCode() : 0);
        result = 31 * result + (this.messageIdentifier != null ? this.messageIdentifier.hashCode() : 0);
        result = 31 * result + (this.transportProtocol != null ? this.transportProtocol.hashCode() : 0);
        result = 31 * result + (this.transmissionRole != null ? this.transmissionRole.hashCode() : 0);
        result = 31 * result + this.originalReceipts.hashCode();
        return result;
    }

    public String toString() {
        return "Evidence{type=" + this.type + ",\n eventCode=" + this.eventCode + ",\n eventReason=" + this.eventReason + ",\n issuer=" + this.issuer + ",\n evidenceIdentifier=" + this.evidenceIdentifier + ",\n timestamp=" + this.timestamp + ",\n sender=" + this.sender + ",\n receiver=" + this.receiver + ",\n documentTypeIdentifier=" + this.documentTypeIdentifier + ",\n documentIdentifier=" + this.documentIdentifier + ",\n issuerPolicy=" + this.issuerPolicy + ",\n digest=" + this.digest + ",\n messageIdentifier=" + this.messageIdentifier + ",\n transportProtocol=" + this.transportProtocol + ",\n transmissionRole=" + this.transmissionRole + ",\n originalReceipts=" + this.originalReceipts + "}";
    }

    private Evidence copy() {
        return new Evidence(this.type, this.eventCode, this.eventReason, this.issuer, this.evidenceIdentifier, this.timestamp, this.sender, this.receiver, this.documentTypeIdentifier, this.documentIdentifier, this.issuerPolicy, this.digest, this.messageIdentifier, this.transportProtocol, this.transmissionRole, this.originalReceipts);
    }
}

