/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.sniffer;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import network.oxalis.sniffer.identifier.InstanceId;
import network.oxalis.sniffer.identifier.PeppolDocumentTypeId;
import network.oxalis.vefa.peppol.common.model.C1CountryIdentifier;
import network.oxalis.vefa.peppol.common.model.DocumentTypeIdentifier;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.common.model.InstanceIdentifier;
import network.oxalis.vefa.peppol.common.model.InstanceType;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.common.model.ProcessIdentifier;

public class PeppolStandardBusinessHeader {
    private ParticipantIdentifier recipientId;
    private ParticipantIdentifier senderId;
    private DocumentTypeIdentifier peppolDocumentTypeId;
    private ProcessIdentifier profileTypeIdentifier;
    private C1CountryIdentifier c1CountryIdentifier;
    private InstanceId instanceId;
    private Date creationDateAndTime;

    public static PeppolStandardBusinessHeader createPeppolStandardBusinessHeaderWithNewDate() {
        PeppolStandardBusinessHeader p = new PeppolStandardBusinessHeader();
        p.setCreationDateAndTime(new Date());
        return p;
    }

    public PeppolStandardBusinessHeader() {
    }

    public PeppolStandardBusinessHeader(Header header) {
        this.senderId = header.getSender();
        this.recipientId = header.getReceiver();
        this.creationDateAndTime = header.getCreationTimestamp();
        this.peppolDocumentTypeId = header.getDocumentType();
        this.profileTypeIdentifier = header.getProcess();
        this.c1CountryIdentifier = header.getC1CountryIdentifier();
        this.instanceId = new InstanceId(header.getIdentifier().getIdentifier());
    }

    public PeppolStandardBusinessHeader(PeppolStandardBusinessHeader peppolStandardBusinessHeader) {
        this.recipientId = peppolStandardBusinessHeader.getRecipientId();
        this.senderId = peppolStandardBusinessHeader.getSenderId();
        this.peppolDocumentTypeId = peppolStandardBusinessHeader.getDocumentTypeIdentifier();
        this.profileTypeIdentifier = peppolStandardBusinessHeader.getProfileTypeIdentifier();
        this.c1CountryIdentifier = peppolStandardBusinessHeader.getC1CountryIdentifier();
        this.instanceId = peppolStandardBusinessHeader.getInstanceId();
        this.creationDateAndTime = peppolStandardBusinessHeader.getCreationDateAndTime();
    }

    public boolean isComplete() {
        return this.recipientId != null && this.senderId != null && this.peppolDocumentTypeId != null && this.profileTypeIdentifier != null && this.c1CountryIdentifier != null && this.instanceId != null && this.creationDateAndTime != null;
    }

    public List<String> listMissingProperties() {
        ArrayList<String> mhf = new ArrayList<String>();
        if (this.recipientId == null) {
            mhf.add("recipientId");
        }
        if (this.senderId == null) {
            mhf.add("senderId");
        }
        if (this.peppolDocumentTypeId == null) {
            mhf.add("peppolDocumentTypeId");
        }
        if (this.profileTypeIdentifier == null) {
            mhf.add("profileTypeIdentifier");
        }
        if (this.c1CountryIdentifier == null) {
            mhf.add("c1CountryIdentifier");
        }
        if (this.instanceId == null) {
            mhf.add("messageId");
        }
        if (this.creationDateAndTime == null) {
            mhf.add("creationDateAndTime");
        }
        return mhf;
    }

    public void setRecipientId(ParticipantIdentifier recipientId) {
        this.recipientId = recipientId;
    }

    public ParticipantIdentifier getRecipientId() {
        return this.recipientId;
    }

    public void setSenderId(ParticipantIdentifier senderId) {
        this.senderId = senderId;
    }

    public ParticipantIdentifier getSenderId() {
        return this.senderId;
    }

    public void setInstanceId(InstanceId instanceId) {
        this.instanceId = instanceId;
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public void setCreationDateAndTime(Date creationDateAndTime) {
        this.creationDateAndTime = creationDateAndTime;
    }

    public Date getCreationDateAndTime() {
        return this.creationDateAndTime;
    }

    @Deprecated
    public void setDocumentTypeIdentifier(PeppolDocumentTypeId documentTypeIdentifier) {
        this.setDocumentTypeIdentifier(documentTypeIdentifier.toVefa());
    }

    public void setDocumentTypeIdentifier(DocumentTypeIdentifier documentTypeIdentifier) {
        this.peppolDocumentTypeId = documentTypeIdentifier;
    }

    public DocumentTypeIdentifier getDocumentTypeIdentifier() {
        return this.peppolDocumentTypeId;
    }

    public void setProfileTypeIdentifier(ProcessIdentifier processIdentifier) {
        this.profileTypeIdentifier = processIdentifier;
    }

    public ProcessIdentifier getProfileTypeIdentifier() {
        return this.profileTypeIdentifier;
    }

    public C1CountryIdentifier getC1CountryIdentifier() {
        return this.c1CountryIdentifier;
    }

    public void setC1CountryIdentifier(C1CountryIdentifier c1CountryIdentifier) {
        this.c1CountryIdentifier = c1CountryIdentifier;
    }

    public Header toVefa() {
        PeppolDocumentTypeId documentTypeId = PeppolDocumentTypeId.valueOf(this.peppolDocumentTypeId.getIdentifier());
        return Header.of((ParticipantIdentifier)this.senderId, (ParticipantIdentifier)this.recipientId, (ProcessIdentifier)this.profileTypeIdentifier, (DocumentTypeIdentifier)this.peppolDocumentTypeId, (C1CountryIdentifier)this.c1CountryIdentifier, (InstanceIdentifier)(this.instanceId == null ? InstanceIdentifier.generateUUID() : this.instanceId.toVefa()), (InstanceType)InstanceType.of((String)documentTypeId.getRootNameSpace(), (String)documentTypeId.getLocalName(), (String)documentTypeId.getVersion()), (Date)this.creationDateAndTime);
    }
}

