/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ext.testbed.v1;

import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import network.oxalis.api.evidence.EvidenceFactory;
import network.oxalis.api.inbound.InboundMetadata;
import network.oxalis.api.lang.EvidenceException;
import network.oxalis.api.model.TransmissionIdentifier;
import network.oxalis.api.persist.PersisterHandler;
import network.oxalis.api.transmission.TransmissionResult;
import network.oxalis.api.util.Type;
import network.oxalis.ext.testbed.v1.TestbedSender;
import network.oxalis.ext.testbed.v1.jaxb.InboundType;
import network.oxalis.vefa.peppol.common.model.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Type(value={"testbed-v1"})
public class TestbedPersisterHandler
implements PersisterHandler {
    private static final Logger log = LoggerFactory.getLogger(TestbedPersisterHandler.class);
    @Inject
    @Named(value="rem")
    private EvidenceFactory evidenceFactory;
    @Inject
    private TestbedSender sender;

    public Path persist(TransmissionIdentifier transmissionIdentifier, Header header, InputStream inputStream) throws IOException {
        Path path = File.createTempFile("oxalis-testbed-inbound", header.getIdentifier().getIdentifier()).toPath();
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        return path;
    }

    public void persist(InboundMetadata inboundMetadata, Path payloadPath) throws IOException {
        try (InputStream inputStream = Files.newInputStream(payloadPath, new OpenOption[0]);){
            InboundType inbound = new InboundType();
            inbound.setTransportProfile(inboundMetadata.getProtocol().getIdentifier());
            inbound.setPayload(ByteStreams.toByteArray((InputStream)inputStream));
            inbound.setReceipt(ByteStreams.toByteArray((InputStream)this.evidenceFactory.write((TransmissionResult)inboundMetadata)));
            this.sender.send(inbound);
        }
        catch (EvidenceException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Files.delete(payloadPath);
    }
}

