/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.mode;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import io.opentelemetry.api.trace.Span;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import network.oxalis.pkix.ocsp.api.OcspFetcher;
import network.oxalis.pkix.ocsp.api.OcspFetcherResponse;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

@Singleton
public class OxalisOcspFetcher
implements OcspFetcher {
    @Inject
    private Provider<CloseableHttpClient> httpClientProvider;
    @Inject
    @Named(value="certificate")
    private RequestConfig requestConfig;

    public OcspFetcherResponse fetch(URI uri, byte[] content) throws IOException {
        Span span = Span.current();
        BasicHttpContext basicHttpContext = new BasicHttpContext();
        if (span != null) {
            basicHttpContext.setAttribute(OxalisOcspFetcher.class.getName() + ".parentSpanContext", (Object)span.getSpanContext());
        }
        HttpPost httpPost = new HttpPost(uri);
        httpPost.setHeader("Content-Type", "application/ocsp-request");
        httpPost.setHeader("Accept", "application/ocsp-response");
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(content));
        httpPost.setConfig(this.requestConfig);
        return new ApacheOcspFetcherResponse(((CloseableHttpClient)this.httpClientProvider.get()).execute((HttpUriRequest)httpPost, (HttpContext)basicHttpContext));
    }

    private class ApacheOcspFetcherResponse
    implements OcspFetcherResponse {
        private CloseableHttpResponse response;

        public ApacheOcspFetcherResponse(CloseableHttpResponse response) {
            this.response = response;
        }

        public int getStatus() {
            return this.response.getStatusLine().getStatusCode();
        }

        public String getContentType() {
            return this.response.getFirstHeader("Content-Type").getValue();
        }

        public InputStream getContent() throws IOException {
            return this.response.getEntity().getContent();
        }

        public void close() throws IOException {
            this.response.close();
            this.response = null;
        }
    }
}

