/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.commons.certvalidator.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLConnection;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import network.oxalis.commons.certvalidator.api.CertificateValidationException;
import network.oxalis.commons.certvalidator.api.CrlCache;
import network.oxalis.commons.certvalidator.api.CrlFetcher;
import network.oxalis.commons.certvalidator.util.CrlUtils;

public class SimpleCachingCrlFetcher
implements CrlFetcher {
    protected CrlCache crlCache;

    public SimpleCachingCrlFetcher(CrlCache crlCache) {
        this.crlCache = crlCache;
    }

    @Override
    public X509CRL get(String url) throws CertificateValidationException {
        X509CRL crl = this.crlCache.get(url);
        if (crl == null) {
            crl = this.download(url);
        } else if (crl.getNextUpdate() != null && crl.getNextUpdate().getTime() < System.currentTimeMillis()) {
            crl = this.download(url);
        } else if (crl.getNextUpdate() == null) {
            // empty if block
        }
        return crl;
    }

    protected X509CRL download(String url) throws CertificateValidationException {
        if (url != null && url.matches("http[s]{0,1}://.*")) {
            X509CRL crl = this.httpDownload(url);
            this.crlCache.set(url, crl);
            return crl;
        }
        if (url != null && url.startsWith("ldap://")) {
            return null;
        }
        return null;
    }

    protected X509CRL httpDownload(String url) throws CertificateValidationException {
        try {
            URLConnection urlConnection = URI.create(url).toURL().openConnection();
            urlConnection.setConnectTimeout(30000);
            urlConnection.setReadTimeout(30000);
            InputStream inputStream = urlConnection.getInputStream();
            return CrlUtils.load(inputStream);
        }
        catch (IOException | CRLException e) {
            throw new CertificateValidationException(String.format("Failed to download CRL '%s' (%s)", url, e.getMessage()), e);
        }
    }
}

