/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.inbound;

import com.google.inject.Inject;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import network.oxalis.api.header.HeaderParser;
import network.oxalis.api.identifier.MessageIdGenerator;
import network.oxalis.api.inbound.InboundMetadata;
import network.oxalis.api.inbound.InboundService;
import network.oxalis.api.lang.OxalisContentException;
import network.oxalis.api.lang.OxalisSecurityException;
import network.oxalis.api.lang.VerifierException;
import network.oxalis.api.model.Direction;
import network.oxalis.api.model.TransmissionIdentifier;
import network.oxalis.api.persist.PersisterHandler;
import network.oxalis.api.tag.Tag;
import network.oxalis.api.tag.TagGenerator;
import network.oxalis.api.timestamp.Timestamp;
import network.oxalis.api.timestamp.TimestampProvider;
import network.oxalis.api.transmission.TransmissionVerifier;
import network.oxalis.as2.code.Disposition;
import network.oxalis.as2.inbound.As2InboundMetadata;
import network.oxalis.as2.lang.OxalisAs2InboundException;
import network.oxalis.as2.model.Mic;
import network.oxalis.as2.util.MdnBuilder;
import network.oxalis.as2.util.MessageIdUtil;
import network.oxalis.as2.util.SMimeDigestMethod;
import network.oxalis.as2.util.SMimeMessageFactory;
import network.oxalis.as2.util.SignedMessage;
import network.oxalis.commons.mode.OxalisCertificateValidator;
import network.oxalis.vefa.peppol.common.code.DigestMethod;
import network.oxalis.vefa.peppol.common.code.Service;
import network.oxalis.vefa.peppol.common.model.Digest;
import network.oxalis.vefa.peppol.common.model.Header;
import network.oxalis.vefa.peppol.security.api.CertificateValidator;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;

class As2InboundHandler {
    private final InboundService inboundService;
    private final TimestampProvider timestampProvider;
    private final PersisterHandler persisterHandler;
    private final TransmissionVerifier transmissionVerifier;
    private final OxalisCertificateValidator certificateValidator;
    private final SMimeMessageFactory sMimeMessageFactory;
    private final TagGenerator tagGenerator;
    private final MessageIdGenerator messageIdGenerator;
    private final HeaderParser headerParser;

    @Inject
    public As2InboundHandler(InboundService inboundService, TimestampProvider timestampProvider, OxalisCertificateValidator certificateValidator, PersisterHandler persisterHandler, TransmissionVerifier transmissionVerifier, SMimeMessageFactory sMimeMessageFactory, TagGenerator tagGenerator, MessageIdGenerator messageIdGenerator, HeaderParser headerParser) {
        this.inboundService = inboundService;
        this.timestampProvider = timestampProvider;
        this.certificateValidator = certificateValidator;
        this.persisterHandler = persisterHandler;
        this.transmissionVerifier = transmissionVerifier;
        this.sMimeMessageFactory = sMimeMessageFactory;
        this.tagGenerator = tagGenerator;
        this.messageIdGenerator = messageIdGenerator;
        this.headerParser = headerParser;
    }

    public MimeMessage receive(InternetHeaders httpHeaders, MimeMessage mimeMessage) throws OxalisAs2InboundException {
        TransmissionIdentifier transmissionIdentifier = null;
        Header header = null;
        Path payloadPath = null;
        try {
            SignedMessage message = SignedMessage.load(mimeMessage);
            message.validate(Service.AP, (CertificateValidator)this.certificateValidator, httpHeaders.getHeader("AS2-From")[0].replace("\"", ""));
            Timestamp t2 = this.timestampProvider.generate(message.getSignature(), Direction.IN);
            Tag tag = this.tagGenerator.generate(Direction.IN);
            MdnBuilder mdnBuilder = MdnBuilder.newInstance(mimeMessage);
            mdnBuilder.addHeader("Date", t2.getDate());
            transmissionIdentifier = TransmissionIdentifier.fromHeader((String)httpHeaders.getHeader("Message-Id")[0]);
            mdnBuilder.addHeader("Original-Message-ID", httpHeaders.getHeader("Message-Id")[0]);
            SMimeDigestMethod digestMethod = SMimeDigestMethod.findByIdentifier(message.getMicalg());
            byte[] headerBytes = message.getBodyHeader();
            mdnBuilder.addHeader("X-Oxalis-Original-Content-Header", headerBytes);
            byte[] content = message.getContentBytes();
            header = this.headerParser.parse((InputStream)new ByteArrayInputStream(content));
            this.transmissionVerifier.verify(header, Direction.IN);
            try (ByteArrayInputStream payloadInputStream = new ByteArrayInputStream(content);){
                payloadPath = this.persisterHandler.persist(transmissionIdentifier, header, (InputStream)payloadInputStream);
            }
            Digest calculatedDigest = Digest.of((DigestMethod)digestMethod.getDigestMethod(), (byte[])message.getDigest());
            mdnBuilder.addHeader("Received-Content-Mic", new Mic(calculatedDigest));
            String messageId = this.messageIdGenerator.generate((InboundMetadata)new As2InboundMetadata(transmissionIdentifier, header, t2, null, null, message.getSigner(), null, tag));
            if (!MessageIdUtil.verify(messageId)) {
                throw new OxalisAs2InboundException("Invalid Message-ID '" + messageId + "' generated.", Disposition.UNEXPECTED_PROCESSING_ERROR);
            }
            mdnBuilder.addHeader("Disposition", Disposition.PROCESSED);
            MimeMessage mdn = this.sMimeMessageFactory.createSignedMimeMessage(mdnBuilder.build(), digestMethod);
            mdn.setHeader("Message-Id", messageId);
            mdn.setHeader("AS2-Version", "1.0");
            mdn.setHeader("AS2-From", httpHeaders.getHeader("AS2-To")[0]);
            mdn.setHeader("AS2-To", httpHeaders.getHeader("AS2-From")[0]);
            ByteArrayOutputStream mdnOutputStream = new ByteArrayOutputStream();
            mdn.writeTo((OutputStream)mdnOutputStream);
            As2InboundMetadata inboundMetadata = new As2InboundMetadata(transmissionIdentifier, header, t2, digestMethod.getTransportProfile(), calculatedDigest, message.getSigner(), mdnOutputStream.toByteArray(), tag);
            this.persisterHandler.persist((InboundMetadata)inboundMetadata, payloadPath);
            this.inboundService.complete((InboundMetadata)inboundMetadata);
            return mdn;
        }
        catch (OxalisContentException e) {
            OxalisAs2InboundException exception = new OxalisAs2InboundException(Disposition.UNSUPPORTED_FORMAT, e.getMessage(), e);
            this.persisterHandler.persist(transmissionIdentifier, header, payloadPath, (Exception)((Object)exception));
            throw exception;
        }
        catch (NoSuchAlgorithmException e) {
            OxalisAs2InboundException exception = new OxalisAs2InboundException(Disposition.UNSUPPORTED_MIC_ALGORITHMS, e.getMessage(), e);
            this.persisterHandler.persist(transmissionIdentifier, header, payloadPath, (Exception)((Object)exception));
            throw exception;
        }
        catch (VerifierException e) {
            OxalisAs2InboundException exception = new OxalisAs2InboundException(Disposition.fromVerifierException(e), e.getMessage(), e);
            this.persisterHandler.persist(transmissionIdentifier, header, payloadPath, (Exception)((Object)exception));
            throw exception;
        }
        catch (PeppolSecurityException e) {
            OxalisAs2InboundException exception = new OxalisAs2InboundException(Disposition.AUTHENTICATION_FAILED, e.getMessage(), e);
            this.persisterHandler.persist(transmissionIdentifier, header, payloadPath, (Exception)((Object)exception));
            throw exception;
        }
        catch (OxalisSecurityException e) {
            OxalisAs2InboundException exception = new OxalisAs2InboundException(Disposition.INTEGRITY_CHECK_FAILED, e.getMessage(), e);
            this.persisterHandler.persist(transmissionIdentifier, header, payloadPath, (Exception)((Object)exception));
            throw exception;
        }
        catch (Exception e) {
            OxalisAs2InboundException exception = new OxalisAs2InboundException(Disposition.UNEXPECTED_PROCESSING_ERROR, e.getMessage(), e);
            this.persisterHandler.persist(transmissionIdentifier, header, payloadPath, (Exception)((Object)exception));
            throw exception;
        }
    }
}

