/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.util;

import jakarta.mail.BodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import network.oxalis.as2.model.As2Disposition;
import network.oxalis.as2.model.Mic;
import org.apache.commons.codec.binary.Base64InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdnMimeMessageInspector {
    private static final Logger log = LoggerFactory.getLogger(MdnMimeMessageInspector.class);
    private final MimeMessage mdnMimeMessage;

    public MdnMimeMessageInspector(MimeMessage mdnMimeMessage) {
        this.mdnMimeMessage = mdnMimeMessage;
    }

    public MimeMultipart getSignedMultiPart() {
        try {
            return (MimeMultipart)this.mdnMimeMessage.getContent();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to access the contents of the MDN S/MIME message: " + e.getMessage(), e);
        }
    }

    public MimeMultipart getMultipartReport() {
        try {
            BodyPart bodyPart = this.getSignedMultiPart().getBodyPart(0);
            MimeMultipart multipartReport = new MimeMultipart(bodyPart.getDataHandler().getDataSource());
            if (!MdnMimeMessageInspector.containsIgnoreCase(multipartReport.getContentType(), "multipart/report")) {
                throw new IllegalStateException("The first body part of the first part of the signed message is not a multipart/report");
            }
            return multipartReport;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to retrieve the multipart/report : " + e.getMessage(), e);
        }
    }

    public BodyPart getPlainTextBodyPart() {
        return this.getPartFromMultipartReport("text/plain");
    }

    public BodyPart getMessageDispositionNotificationPart() {
        BodyPart bp = this.getPartFromMultipartReport("message/disposition-notification");
        if (bp == null) {
            bp = this.getBodyPartAt(1);
        }
        return bp;
    }

    private BodyPart getPartFromMultipartReport(String contentType) {
        try {
            MimeMultipart multipartReport = this.getMultipartReport();
            for (int t = 0; t < multipartReport.getCount(); ++t) {
                BodyPart bp = multipartReport.getBodyPart(t);
                if (!MdnMimeMessageInspector.containsIgnoreCase(bp.getContentType(), contentType)) continue;
                return bp;
            }
        }
        catch (Exception e) {
            log.error("Failed to locate part of multipart/report of type '{}'.", (Object)contentType, (Object)e);
        }
        return null;
    }

    private BodyPart getBodyPartAt(int position) {
        try {
            return this.getMultipartReport().getBodyPart(position);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to retrieve the body part at position " + position + " : " + e.getMessage(), e);
        }
    }

    public String getPlainTextPartAsText() {
        try {
            return this.getPlainTextBodyPart().getContent().toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to retrieve the plain text from the MDN: " + e.getMessage(), e);
        }
    }

    public Map<String, String> getMdnFields() {
        TreeMap<String, String> ret;
        block9: {
            ret = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            try {
                Object content;
                BodyPart bp = this.getMessageDispositionNotificationPart();
                boolean contentIsBase64Encoded = false;
                String[] contentTransferEncodings = bp.getHeader("Content-Transfer-Encoding");
                if (contentTransferEncodings != null && contentTransferEncodings.length > 0) {
                    String encoding;
                    if (contentTransferEncodings.length > 1) {
                        log.warn("MDN has multiple Content-Transfer-Encoding, we only try the first one");
                    }
                    if ((encoding = contentTransferEncodings[0]) == null) {
                        encoding = "";
                    }
                    encoding = encoding.trim();
                    log.debug("MDN specifies Content-Transfer-Encoding : '" + encoding + "'");
                    if ("base64".equalsIgnoreCase(encoding)) {
                        contentIsBase64Encoded = true;
                    }
                }
                if ((content = bp.getContent()) instanceof InputStream) {
                    InputStream contentInputStream = (InputStream)content;
                    if (contentIsBase64Encoded) {
                        log.debug("MDN seems to be base64 encoded, wrapping content stream in Base64 decoding stream");
                        contentInputStream = new Base64InputStream(contentInputStream);
                    }
                    BufferedReader r = new BufferedReader(new InputStreamReader(contentInputStream));
                    while (r.ready()) {
                        String line = r.readLine();
                        int firstColon = line.indexOf(":");
                        if (firstColon <= 0) continue;
                        String key = line.substring(0, firstColon).trim();
                        String value = line.substring(firstColon + 1).trim();
                        ret.put(key, value);
                    }
                    break block9;
                }
                throw new Exception("Unsupported MDN content, expected InputStream found @ " + content.toString());
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to retrieve the values from the MDN : " + e.getMessage(), e);
            }
        }
        return ret;
    }

    public boolean isOkOrWarning(Mic outboundMic) throws NoSuchAlgorithmException {
        Map<String, String> mdnFields = this.getMdnFields();
        String disposition = mdnFields.get("Disposition");
        if (disposition == null) {
            log.error("Unable to retreieve 'Disposition' from MDN");
            return false;
        }
        log.debug("Decoding received disposition ({})", (Object)disposition);
        As2Disposition as2dis = As2Disposition.valueOf(disposition);
        if (!As2Disposition.DispositionType.PROCESSED.equals((Object)as2dis.getDispositionType())) {
            log.error("Failed or unknown state: {}", (Object)disposition);
            return false;
        }
        String receivedMic = mdnFields.get("Received-Content-MIC");
        if (receivedMic == null) {
            log.error("MIC error, no Received-Content-MIC returned in MDN");
            return false;
        }
        if (!outboundMic.equals(Mic.valueOf(receivedMic))) {
            log.warn("MIC mismatch, received MIC was '{}' while sent MIC was '{}'.", (Object)receivedMic, (Object)outboundMic.toString());
            return false;
        }
        As2Disposition.DispositionModifier modifier = as2dis.getDispositionModifier();
        if (modifier == null) {
            return true;
        }
        if (As2Disposition.DispositionModifier.Prefix.WARNING.equals((Object)modifier.getPrefix())) {
            log.warn("Returns with warning: {}", (Object)disposition);
            return true;
        }
        log.warn("MDN failed with disposition raw: {}", (Object)disposition);
        log.warn("MDN failed with as2 disposition: {}", (Object)as2dis.toString());
        return false;
    }

    private static boolean containsIgnoreCase(String containerString, String s) {
        if (containerString == null || s == null) {
            return false;
        }
        return containerString.toLowerCase(Locale.ROOT).contains(s.toLowerCase(Locale.ROOT));
    }
}

