/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ext.testbed.v1;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import network.oxalis.ext.testbed.v1.TestbedSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TestbedFilter
extends HttpFilter {
    private static final Logger log = LoggerFactory.getLogger(TestbedFilter.class);
    @Inject
    private TestbedSecurity security;

    protected void doFilter(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getHeader("Authorization") == null) {
            this.noAccess(res);
            return;
        }
        List parts = Stream.of(req.getHeader("Authorization").trim().split("\\s+", 2)).map(String::trim).collect(Collectors.toList());
        if (parts.size() != 2 || !((String)parts.get(0)).equals("Digest")) {
            this.noAccess(res);
            return;
        }
        if (!((String)parts.get(1)).equals(this.security.getExpectedAuthorization())) {
            this.noAccess(res);
            return;
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private void noAccess(HttpServletResponse res) throws IOException {
        res.setStatus(401);
        res.getWriter().write("No access.");
    }
}

