/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.fetcher;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import network.oxalis.vefa.peppol.lookup.api.FetcherResponse;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.fetcher.BasicApacheFetcher;
import network.oxalis.vefa.peppol.mode.Mode;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;

public class ApacheFetcher
extends BasicApacheFetcher {
    private final PoolingHttpClientConnectionManager httpClientConnectionManager = new PoolingHttpClientConnectionManager();

    public ApacheFetcher(Mode mode) {
        super(mode);
    }

    protected CloseableHttpClient createClient() {
        return HttpClients.custom().setDefaultRequestConfig(this.requestConfig).setConnectionManager((HttpClientConnectionManager)this.httpClientConnectionManager).setConnectionManagerShared(true).build();
    }

    @Override
    public FetcherResponse fetch(List<URI> uriList) throws LookupException, FileNotFoundException {
        FetcherResponse fetcherResponse = null;
        Object exceptionObj = null;
        if (uriList == null || uriList.isEmpty()) {
            throw new LookupException("Unable to lookup requested URL or SMP registration is not valid.");
        }
        for (URI uri : uriList) {
            try {
                fetcherResponse = this.fetchResponseFromValidUri(uri);
                if (fetcherResponse == null) continue;
                exceptionObj = null;
                break;
            }
            catch (FileNotFoundException | LookupException e) {
                exceptionObj = e;
            }
        }
        if (exceptionObj instanceof FileNotFoundException) {
            throw new FileNotFoundException();
        }
        if (exceptionObj instanceof LookupException) {
            throw new LookupException(((Throwable)exceptionObj).getMessage(), (Throwable)exceptionObj);
        }
        return fetcherResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FetcherResponse fetchResponseFromValidUri(URI uri) throws LookupException, FileNotFoundException {
        try (CloseableHttpClient httpClient = this.createClient();){
            HttpGet httpGet = new HttpGet(uri);
            try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpGet);){
                int statusCode = response.getCode();
                switch (statusCode) {
                    case 200: {
                        FetcherResponse fetcherResponse = new FetcherResponse(new ByteArrayInputStream(ByteStreams.toByteArray((InputStream)response.getEntity().getContent())), response.containsHeader("X-SMP-Namespace") ? response.getFirstHeader("X-SMP-Namespace").getValue() : null);
                        return fetcherResponse;
                    }
                    case 404: {
                        throw new FileNotFoundException(uri.toString());
                    }
                }
                throw new LookupException(String.format("Received code %s for lookup. URI: %s", statusCode, uri));
            }
        }
        catch (SocketException | SocketTimeoutException | UnknownHostException e) {
            throw new LookupException(String.format("Unable to fetch '%s'", uri), e);
        }
        catch (FileNotFoundException | LookupException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LookupException(e.getMessage(), e);
        }
    }
}

