/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.as2.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public enum As2DateUtil {
    RFC822("EEE, dd MMM yyyy HH:mm:ss Z"),
    ISO8601("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    private String format;

    private As2DateUtil(String format) {
        this.format = format;
    }

    public Date parse(String s) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.format, Locale.ENGLISH);
        try {
            return simpleDateFormat.parse(s);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public String format(Date d) {
        return new SimpleDateFormat(this.format, Locale.ENGLISH).format(d);
    }
}

