/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.ext.testbed.v1;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import network.oxalis.api.settings.Settings;
import network.oxalis.ext.testbed.v1.TestbedConf;
import network.oxalis.ext.testbed.v1.TestbedJaxb;
import network.oxalis.ext.testbed.v1.TestbedSecurity;
import network.oxalis.ext.testbed.v1.jaxb.ErrorType;
import network.oxalis.ext.testbed.v1.jaxb.InboundType;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TestbedSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestbedSender.class);
    @Inject
    private TestbedSecurity security;
    @Inject
    private Settings<TestbedConf> settings;
    @Inject
    private CloseableHttpClient httpClient;

    public void send(InboundType inbound) throws IOException {
        try {
            HttpPost httpPost = new HttpPost(this.settings.getString((Object)TestbedConf.CONTROLLER));
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(this.prepareContent(TestbedJaxb.OBJECT_FACTORY.createInbound(inbound)), ContentType.APPLICATION_XML));
            CloseableHttpResponse response = this.send((HttpUriRequest)httpPost);
            if (response != null) {
                response.close();
            }
        }
        catch (JAXBException e) {
            throw new IOException("Unable to create document to send to testbed controller.", e);
        }
    }

    public void send(ErrorType error) {
        try {
            HttpPut httpPut = new HttpPut(this.settings.getString((Object)TestbedConf.CONTROLLER));
            httpPut.setEntity((HttpEntity)new ByteArrayEntity(this.prepareContent(TestbedJaxb.OBJECT_FACTORY.createError(error)), ContentType.APPLICATION_XML));
            CloseableHttpResponse response = this.send((HttpUriRequest)httpPut);
            if (response != null) {
                response.close();
            }
        }
        catch (JAXBException | IOException e) {
            log.warn("Unable to send error to testbed controller.", e);
        }
    }

    private byte[] prepareContent(JAXBElement<?> element) throws JAXBException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TestbedJaxb.marshaller().marshal(element, (OutputStream)baos);
        return baos.toByteArray();
    }

    private CloseableHttpResponse send(HttpUriRequest request) throws IOException {
        request.addHeader("Authorization", (Object)String.format("Digest %s", this.security.getExpectedAuthorization()));
        return this.httpClient.execute((ClassicHttpRequest)request);
    }
}

