/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.evidence.rem;

import java.io.OutputStream;
import java.security.KeyStore;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import network.oxalis.vefa.peppol.evidence.lang.RemEvidenceException;
import network.oxalis.vefa.peppol.evidence.rem.Evidence;
import network.oxalis.vefa.peppol.evidence.rem.EvidenceWriter;
import network.oxalis.vefa.peppol.evidence.rem.RemHelper;
import network.oxalis.vefa.peppol.security.lang.PeppolSecurityException;
import network.oxalis.vefa.peppol.security.xmldsig.XmldsigSigner;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SignedEvidenceWriter {
    public static void write(OutputStream outputStream, KeyStore.PrivateKeyEntry privateKeyEntry, Evidence evidence) throws RemEvidenceException, PeppolSecurityException {
        SignedEvidenceWriter.write(privateKeyEntry, evidence, new StreamResult(outputStream));
    }

    public static Document write(KeyStore.PrivateKeyEntry privateKeyEntry, Evidence evidence) throws RemEvidenceException, PeppolSecurityException {
        Document document = RemHelper.getDocumentBuilder().newDocument();
        SignedEvidenceWriter.write(document, privateKeyEntry, evidence);
        return document;
    }

    public static void write(Node node, KeyStore.PrivateKeyEntry privateKeyEntry, Evidence evidence) throws RemEvidenceException, PeppolSecurityException {
        SignedEvidenceWriter.write(privateKeyEntry, evidence, new DOMResult(node));
    }

    public static void write(KeyStore.PrivateKeyEntry privateKeyEntry, Evidence evidence, Result result) throws RemEvidenceException, PeppolSecurityException {
        Document document = RemHelper.getDocumentBuilder().newDocument();
        EvidenceWriter.write(document, evidence);
        XmldsigSigner.SHA256().sign(document, privateKeyEntry, result);
    }
}

