/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.vefa.peppol.lookup.locator;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import network.oxalis.vefa.peppol.common.model.ParticipantIdentifier;
import network.oxalis.vefa.peppol.lookup.api.LookupException;
import network.oxalis.vefa.peppol.lookup.api.NotFoundException;
import network.oxalis.vefa.peppol.lookup.locator.AbstractLocator;
import network.oxalis.vefa.peppol.lookup.locator.CustomExtendedDNSResolver;
import network.oxalis.vefa.peppol.lookup.util.DynamicHostnameGenerator;
import network.oxalis.vefa.peppol.mode.Mode;
import org.apache.commons.lang3.StringUtils;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TextParseException;

public class BusdoxLocator
extends AbstractLocator {
    private final long timeout;
    private final int maxRetries;
    private final boolean enablePublicDNS;
    private static final List<InetAddress> customDNSServers = new ArrayList<InetAddress>();
    public static InetAddress GOOGLE_PRIMARY_DNS;
    public static InetAddress GOOGLE_SECONDARY_DNS;
    public static InetAddress CLOUDFLARE_PRIMARY_DNS;
    public static InetAddress CLOUDFLARE_SECONDARY_DNS;
    private final DynamicHostnameGenerator hostnameGenerator;

    public BusdoxLocator(Mode mode) {
        this(mode.getString("lookup.locator.busdox.prefix"), mode.getString("lookup.locator.hostname"), mode.getString("lookup.locator.busdox.algorithm"), Long.parseLong(mode.getString("lookup.locator.busdox.timeout")), Integer.parseInt(mode.getString("lookup.locator.busdox.maxRetries")), Boolean.parseBoolean(mode.getString("lookup.locator.busdox.enablePublicDNS")));
        try {
            GOOGLE_PRIMARY_DNS = InetAddress.getByAddress(new byte[]{8, 8, 8, 8});
            GOOGLE_SECONDARY_DNS = InetAddress.getByAddress(new byte[]{8, 8, 4, 4});
            CLOUDFLARE_PRIMARY_DNS = InetAddress.getByAddress(new byte[]{1, 1, 1, 1});
            CLOUDFLARE_SECONDARY_DNS = InetAddress.getByAddress(new byte[]{1, 0, 0, 1});
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (this.enablePublicDNS) {
            customDNSServers.add(GOOGLE_PRIMARY_DNS);
            customDNSServers.add(GOOGLE_SECONDARY_DNS);
            customDNSServers.add(CLOUDFLARE_PRIMARY_DNS);
            customDNSServers.add(CLOUDFLARE_SECONDARY_DNS);
        }
    }

    public BusdoxLocator(String hostname) {
        this("B-", hostname, "MD5", 30L, 3, false);
    }

    public BusdoxLocator(String prefix, String hostname, String algorithm, long timeout, int maxRetries, boolean enablePublicDNS) {
        this.timeout = timeout;
        this.maxRetries = maxRetries;
        this.enablePublicDNS = enablePublicDNS;
        this.hostnameGenerator = new DynamicHostnameGenerator(prefix, hostname, algorithm);
    }

    @Override
    public URI lookup(ParticipantIdentifier participantIdentifier) throws LookupException {
        String hostname = this.hostnameGenerator.generate(participantIdentifier);
        try {
            ExtendedResolver extendedResolver;
            if (this.enablePublicDNS) {
                extendedResolver = CustomExtendedDNSResolver.createExtendedResolver(customDNSServers, this.timeout, this.maxRetries);
            } else {
                extendedResolver = new ExtendedResolver();
                try {
                    if (StringUtils.isNotBlank((CharSequence)hostname)) {
                        extendedResolver.addResolver((Resolver)new SimpleResolver(hostname));
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
                extendedResolver.addResolver(Lookup.getDefaultResolver());
            }
            extendedResolver.setRetries(this.maxRetries);
            extendedResolver.setTimeout(Duration.ofSeconds(this.timeout));
            Lookup lookup = new Lookup(hostname);
            lookup.setResolver((Resolver)extendedResolver);
            int retryCountLeft = this.maxRetries;
            do {
                lookup.run();
            } while (lookup.getResult() == 2 && --retryCountLeft >= 0);
            if (lookup.getResult() == 2) {
                extendedResolver.setTCP(true);
                retryCountLeft = this.maxRetries;
                do {
                    lookup.run();
                } while (lookup.getResult() == 2 && --retryCountLeft >= 0);
            }
            if (lookup.getResult() != 0) {
                switch (lookup.getResult()) {
                    case 3: {
                        throw new NotFoundException(String.format("Identifier '%s' is not registered in SML. The host '%s' does not exist", participantIdentifier.getIdentifier(), hostname));
                    }
                    case 4: {
                        throw new NotFoundException(String.format("Identifier '%s' is not registered in SML. The Host '%s' exists, but has no records associated with the queried type", participantIdentifier.getIdentifier(), hostname));
                    }
                    case 2: {
                        throw new LookupException(String.format("Error when looking up identifier '%s' in SML due to network error. Retry after sometime... DNS-Lookup-Err: %s", participantIdentifier.getIdentifier(), lookup.getErrorString()));
                    }
                    case 1: {
                        throw new LookupException(String.format("Error when looking up identifier '%s' in SML due to a data or server error. Repeating the lookup immediately would not be helpful. DNS-Lookup-Err: %s", participantIdentifier.getIdentifier(), lookup.getErrorString()));
                    }
                }
                throw new LookupException(String.format("Error when looking up identifier '%s' in SML. DNS-Lookup-Err: %s", participantIdentifier.getIdentifier(), lookup.getErrorString()));
            }
        }
        catch (TextParseException e) {
            throw new LookupException(e.getMessage(), e);
        }
        return URI.create(String.format("http://%s", hostname));
    }
}

