/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.pkix.ocsp;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import network.oxalis.pkix.ocsp.OcspException;
import network.oxalis.pkix.ocsp.OcspRequest;
import network.oxalis.pkix.ocsp.OcspResponse;
import network.oxalis.pkix.ocsp.OcspServerException;
import network.oxalis.pkix.ocsp.api.OcspFetcher;
import network.oxalis.pkix.ocsp.api.OcspFetcherResponse;
import network.oxalis.pkix.ocsp.builder.Properties;
import network.oxalis.pkix.ocsp.builder.Property;
import network.oxalis.pkix.ocsp.fetcher.UrlOcspFetcher;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;

class AbstractOcspClient {
    public static final Property<Boolean> EXCEPTION_ON_NO_PATH = Property.create(false);
    public static final Property<OcspFetcher> FETCHER = Property.create(UrlOcspFetcher.builder().build());
    public static final Property<List<X509Certificate>> INTERMEDIATES = Property.create(Collections.emptyList());
    public static final Property<URI> OVERRIDE_URL = Property.create();
    public static final Property<Boolean> NONCE = Property.create(false);
    protected final Properties properties;

    protected AbstractOcspClient(Properties properties) {
        this.properties = properties;
    }

    protected X509Certificate findIntermediate(X509Certificate certificate) throws OcspException {
        for (X509Certificate issuer : this.properties.get(INTERMEDIATES)) {
            if (!issuer.getSubjectX500Principal().equals(certificate.getIssuerX500Principal())) continue;
            return issuer;
        }
        throw new OcspException("Unable to find issuer '%s'.", certificate.getIssuerX500Principal().getName());
    }

    protected URI detectOcspUri(X509Certificate certificate) throws OcspException {
        byte[] extensionValue = certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (extensionValue == null) {
            OcspException.trigger(this.properties.get(EXCEPTION_ON_NO_PATH), "Unable to detect path for OCSP (%s)", Extension.authorityInfoAccess.getId());
            return null;
        }
        try {
            AuthorityInformationAccess authInfo = AuthorityInformationAccess.getInstance((Object)JcaX509ExtensionUtils.parseExtensionValue((byte[])extensionValue));
            for (AccessDescription accessDescription : authInfo.getAccessDescriptions()) {
                ASN1ObjectIdentifier accessMethod = accessDescription.getAccessMethod();
                GeneralName accessLocation = accessDescription.getAccessLocation();
                if (!X509ObjectIdentifiers.id_ad_ocsp.equals((ASN1Primitive)accessMethod) || 6 != accessLocation.getTagNo()) continue;
                ASN1IA5String uri = ASN1IA5String.getInstance((Object)accessLocation.getName());
                return URI.create(new String(uri.getOctets()));
            }
        }
        catch (Exception e) {
            throw new OcspException("Exception when reading AIA: '%s'.", (Throwable)e, e.getMessage());
        }
        OcspException.trigger(this.properties.get(EXCEPTION_ON_NO_PATH), "Unable to detect path for OCSP in AIA (%s)", Extension.authorityInfoAccess.getId());
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected OcspResponse fetch(OcspRequest ocspReq, URI uri) throws OcspException {
        try (OcspFetcherResponse response = this.properties.get(FETCHER).fetch(uri, ocspReq.generateRequest());){
            OcspResponse ocspResponse;
            block16: {
                if (response.getStatus() != 200) {
                    throw new OcspServerException("Received HTTP code '%s' from responder.", response.getStatus());
                }
                if (!response.getContentType().equalsIgnoreCase("application/ocsp-response")) {
                    throw new OcspServerException("Response was of type '%s'.", response.getContentType());
                }
                InputStream inputStream = response.getContent();
                try {
                    ocspResponse = OcspResponse.parse(uri, inputStream);
                    if (inputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return ocspResponse;
        }
        catch (IOException e) {
            throw new OcspServerException(e.getMessage(), new Object[]{e});
        }
    }
}

