/*
 * Decompiled with CFR 0.152.
 */
package network.oxalis.statistics.service;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.security.cert.X509Certificate;
import network.oxalis.api.inbound.InboundMetadata;
import network.oxalis.api.model.AccessPointIdentifier;
import network.oxalis.api.model.Direction;
import network.oxalis.api.outbound.TransmissionRequest;
import network.oxalis.api.outbound.TransmissionResponse;
import network.oxalis.api.statistics.StatisticsService;
import network.oxalis.api.util.Type;
import network.oxalis.commons.security.CertificateUtils;
import network.oxalis.commons.tracing.Traceable;
import network.oxalis.statistics.api.ChannelId;
import network.oxalis.statistics.api.RawStatisticsRepository;
import network.oxalis.statistics.model.DefaultRawStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Type(value={"default"})
class DefaultStatisticsService
extends Traceable
implements StatisticsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultStatisticsService.class);
    private final RawStatisticsRepository rawStatisticsRepository;
    private final AccessPointIdentifier ourAccessPointIdentifier;

    @Inject
    public DefaultStatisticsService(RawStatisticsRepository rawStatisticsRepository, X509Certificate certificate, Tracer tracer) {
        super(tracer);
        this.rawStatisticsRepository = rawStatisticsRepository;
        this.ourAccessPointIdentifier = new AccessPointIdentifier(CertificateUtils.extractCommonName((X509Certificate)certificate));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(TransmissionRequest transmissionRequest, TransmissionResponse transmissionResponse, Span root) {
        Span span = this.tracer.buildSpan("persist statistics").asChildOf(root).start();
        try {
            DefaultRawStatistics.RawStatisticsBuilder builder = (DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)new DefaultRawStatistics.RawStatisticsBuilder().accessPointIdentifier(this.ourAccessPointIdentifier)).direction(Direction.OUT)).documentType(transmissionResponse.getHeader().getDocumentType())).sender(transmissionResponse.getHeader().getSender()).receiver(transmissionResponse.getHeader().getReceiver()).profile(transmissionResponse.getHeader().getProcess())).date(transmissionResponse.getTimestamp());
            if (transmissionRequest.getEndpoint().getCertificate() != null) {
                String accessPointIdentifierValue = CertificateUtils.extractCommonName((X509Certificate)transmissionRequest.getEndpoint().getCertificate());
                builder.channel(new ChannelId(accessPointIdentifierValue));
            } else {
                String protocolName = transmissionRequest.getEndpoint().getTransportProfile().getIdentifier();
                builder.channel(new ChannelId(protocolName));
            }
            DefaultRawStatistics rawStatistics = builder.build();
            this.rawStatisticsRepository.persist(rawStatistics);
        }
        catch (Exception ex) {
            span.setTag("exception", String.valueOf(ex.getMessage()));
            log.error("Persisting DefaultRawStatistics about oubound transmission failed : {}", (Object)ex.getMessage(), (Object)ex);
        }
        finally {
            span.finish();
        }
    }

    public void persist(InboundMetadata inboundMetadata) {
        try {
            DefaultRawStatistics rawStatistics = ((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)((DefaultRawStatistics.RawStatisticsBuilder)new DefaultRawStatistics.RawStatisticsBuilder().accessPointIdentifier(this.ourAccessPointIdentifier)).direction(Direction.IN)).documentType(inboundMetadata.getHeader().getDocumentType())).sender(inboundMetadata.getHeader().getSender()).receiver(inboundMetadata.getHeader().getReceiver()).profile(inboundMetadata.getHeader().getProcess())).channel(new ChannelId("AS2"))).build();
            this.rawStatisticsRepository.persist(rawStatistics);
        }
        catch (Exception e) {
            log.error("Unable to persist statistics for " + inboundMetadata.toString() + ";\n " + e.getMessage(), (Throwable)e);
        }
    }
}

